/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.codelisthelper.CodelistMappingSession;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4CodelistMapping
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4CodelistMapping.class);
    private TabularDataService service;
    private CodelistMappingSession codelistMappingSession;
    private String importUrl;

    public OpExecution4CodelistMapping(TabularDataService service, CodelistMappingSession codelistMappingSession, String importUrl) {
        this.service = service;
        this.codelistMappingSession = codelistMappingSession;
        this.importUrl = importUrl;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        OperationExecution invocation = null;
        logger.debug(this.codelistMappingSession.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.CodelistMappingImport.toString(), this.service);
        map.put("url", this.importUrl);
        ColumnData columnData = this.codelistMappingSession.getConnectedColumn();
        long tabId = columnData.getTrId().isViewTable() ? new Long(columnData.getTrId().getReferenceTargetTableId()).longValue() : new Long(columnData.getTrId().getTableId()).longValue();
        TableId tableId = new TableId(new Long(tabId).longValue());
        ColumnLocalId columnId = new ColumnLocalId(columnData.getColumnId());
        ColumnReference colRef = new ColumnReference(tableId, columnId);
        map.put("old_codes", (String)colRef);
        invocation = new OperationExecution(operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

