/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DuplicatesSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4Duplicates
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4Duplicates.class);
    private TabularDataService service;
    private DuplicatesSession duplicatesSession;

    public OpExecution4Duplicates(TabularDataService service, DuplicatesSession duplicatesSession) {
        this.service = service;
        this.duplicatesSession = duplicatesSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        OperationExecution invocation = null;
        logger.debug(this.duplicatesSession.toString());
        HashMap map = new HashMap();
        ArrayList<ColumnData> cols = this.duplicatesSession.getColumns();
        logger.debug("ReferenceColumn To Set: " + cols);
        ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>();
        for (ColumnData col : cols) {
            ColumnLocalId cId = new ColumnLocalId(col.getColumnId());
            TRId trId = col.getTrId();
            logger.debug("trID: " + trId);
            long tabId = trId.isViewTable() ? new Long(trId.getReferenceTargetTableId()).longValue() : new Long(trId.getTableId()).longValue();
            TableId tId = new TableId(tabId);
            ColumnReference columnReference = new ColumnReference(tId, cId);
            columnReferences.add(columnReference);
        }
        switch (this.duplicatesSession.getDuplicateOp()) {
            case VALIDATE: {
                OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.DuplicateTupleValidation.toString(), this.service);
                map.put("key", columnReferences);
                invocation = new OperationExecution(operationDefinition.getOperationId(), map);
                break;
            }
            case DELETE: {
                OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.RemoveDuplicateTuples.toString(), this.service);
                map.put("key", columnReferences);
                invocation = new OperationExecution(operationDefinition.getOperationId(), map);
                break;
            }
        }
        this.operationExecutionSpec.setOp(invocation);
    }
}

