/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.geospatial.GeospatialDownscaleCSquareSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4GeospatialDownscaleCSquare
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4GeospatialDownscaleCSquare.class);
    private TabularDataService service;
    private GeospatialDownscaleCSquareSession geospatialDownscaleCSquareSession;

    public OpExecution4GeospatialDownscaleCSquare(TabularDataService service, GeospatialDownscaleCSquareSession geospatialDownscaleCSquareSession) {
        this.service = service;
        this.geospatialDownscaleCSquareSession = geospatialDownscaleCSquareSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        OperationExecution invocation = null;
        logger.debug("Downscale CSquare: " + this.geospatialDownscaleCSquareSession);
        HashMap<String, String> map = new HashMap<String, String>();
        ColumnData col = this.geospatialDownscaleCSquareSession.getCsquareColumn();
        if (col == null || col.getColumnId() == null || col.getColumnId().isEmpty()) {
            logger.error("Error in downscale c-square: no valid column set");
            throw new TDGWTServiceException("No valid column set");
        }
        if (this.geospatialDownscaleCSquareSession.getResolution() == null || this.geospatialDownscaleCSquareSession.getResolution().isEmpty()) {
            logger.error("Error in downscale c-square: no valid resolution set");
            throw new TDGWTServiceException("No valid resolution set");
        }
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.DownscaleCSquare.toString(), this.service);
        map.put("resolution", this.geospatialDownscaleCSquareSession.getResolution());
        invocation = new OperationExecution(col.getColumnId(), operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

