/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.logical.And;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.replacebyexternal.ReplaceByExternalColumnsMapping;
import org.gcube.portlets.user.td.gwtservice.shared.tr.replacebyexternal.ReplaceByExternalSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4ReplaceByExternal
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4ReplaceByExternal.class);
    private TabularDataService service;
    private ReplaceByExternalSession replaceByExternalSession;

    public OpExecution4ReplaceByExternal(TabularDataService service, ReplaceByExternalSession replaceByExternalSession) {
        this.service = service;
        this.replaceByExternalSession = replaceByExternalSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        OperationExecution invocation = null;
        logger.debug(this.replaceByExternalSession.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.ReplaceColumnByExpression.toString(), this.service);
        TableId currentTableId = null;
        currentTableId = this.replaceByExternalSession.getCurrentTabularResource().getTrId().isViewTable() ? new TableId(Long.valueOf(this.replaceByExternalSession.getCurrentTabularResource().getTrId().getReferenceTargetTableId()).longValue()) : new TableId(Long.valueOf(this.replaceByExternalSession.getCurrentTabularResource().getTrId().getTableId()).longValue());
        TableId externalTableId = null;
        externalTableId = this.replaceByExternalSession.getExternalTabularResource().getTrId().isViewTable() ? new TableId(Long.valueOf(this.replaceByExternalSession.getExternalTabularResource().getTrId().getReferenceTargetTableId()).longValue()) : new TableId(Long.valueOf(this.replaceByExternalSession.getExternalTabularResource().getTrId().getTableId()).longValue());
        ArrayList<Equals> conditions = new ArrayList<Equals>();
        for (ReplaceByExternalColumnsMapping colMapping : this.replaceByExternalSession.getColumnsMatch()) {
            ColumnReference currentColumn = new ColumnReference(currentTableId, new ColumnLocalId(colMapping.getCurrentColumn().getColumnId()));
            ColumnReference externalColumn = new ColumnReference(externalTableId, new ColumnLocalId(colMapping.getExternalColumn().getColumnId()));
            Equals eq = new Equals((Expression)currentColumn, (Expression)externalColumn);
            conditions.add(eq);
        }
        Expression condition = null;
        if (conditions.size() <= 0) {
            logger.error("No columns selected");
            throw new TDGWTServiceException("No columns selected");
        }
        if (conditions.size() == 1) {
            condition = (Expression)conditions.get(0);
        } else {
            And andCond = new And(conditions);
            condition = andCond;
        }
        ColumnReference replaceColumn = new ColumnReference(externalTableId, new ColumnLocalId(this.replaceByExternalSession.getReplaceColumn().getColumnId()));
        map.put("condition", condition);
        map.put("value", replaceColumn);
        invocation = new OperationExecution(this.replaceByExternalSession.getCurrentColumn().getColumnId(), operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

