/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ExpressionGenerator;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4ReplaceColumn
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4ReplaceColumn.class);
    private TabularDataService service;
    private ReplaceColumnSession replaceColumnSession;

    public OpExecution4ReplaceColumn(TabularDataService service, ReplaceColumnSession replaceColumnSession) {
        this.service = service;
        this.replaceColumnSession = replaceColumnSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        OperationExecution invocation = null;
        logger.debug(this.replaceColumnSession.toString());
        HashMap<String, Expression> map = new HashMap<String, Expression>();
        if (this.replaceColumnSession.isReplaceDimension()) {
            logger.debug("Is a Replace of view column");
            OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.ReplaceColumnByExpression.toString(), this.service);
            Expression condition = ExpressionGenerator.genReplaceValueParameterCondition(this.replaceColumnSession, this.service);
            Expression value = ExpressionGenerator.genReplaceValueParameterValue(this.replaceColumnSession);
            map.put("condition", condition);
            map.put("value", value);
            invocation = new OperationExecution(this.replaceColumnSession.getColumnData().getColumnViewData().getSourceTableDimensionColumnId(), operationDefinition.getOperationId(), map);
        } else {
            logger.debug("Is a Replace of basic column");
            OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.ReplaceColumnByExpression.toString(), this.service);
            Expression condition = ExpressionGenerator.genReplaceValueParameterCondition(this.replaceColumnSession, this.service);
            Expression value = ExpressionGenerator.genReplaceValueParameterValue(this.replaceColumnSession);
            map.put("condition", condition);
            map.put("value", value);
            invocation = new OperationExecution(this.replaceColumnSession.getColumnData().getColumnId(), operationDefinition.getOperationId(), map);
        }
        this.operationExecutionSpec.setOp(invocation);
    }
}

