/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.groupby.TimeAggregationSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4TimeAggregation
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4TimeAggregation.class);
    private TabularDataService service;
    private TimeAggregationSession timeAggregationSession;

    public OpExecution4TimeAggregation(TabularDataService service, TimeAggregationSession timeAggregationSession) {
        this.service = service;
        this.timeAggregationSession = timeAggregationSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        OperationExecution invocation = null;
        logger.debug(this.timeAggregationSession.toString());
        HashMap<String, Object> map = this.timeAggregationSession.getMap();
        if (map == null) {
            logger.error("In TimeAggregationSession map is null");
            throw new TDGWTServiceException("In TimeAggregationSession map is null");
        }
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.TimeAggregation.toString(), this.service);
        invocation = new OperationExecution(this.timeAggregationSession.getColumn().getColumnId(), operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

