/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.querybuilder.builder;

import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.sdmxsource.sdmx.api.builder.DataQueryBuilder;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.data.query.DataQuery;
import org.sdmxsource.sdmx.api.model.data.query.DataQuerySelection;
import org.sdmxsource.sdmx.api.model.data.query.DataQuerySelectionGroup;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.springframework.stereotype.Service;

@Service
public class DataQueryBuilderRest
implements DataQueryBuilder<String> {
    public String buildDataQuery(DataQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("DataQueryBuilderRest.buildRestDataQuery DataQuery is required, null was passed");
        }
        DataStructureBean keyFamily = query.getDataStructure();
        StringBuilder sb = new StringBuilder();
        sb.append("data/");
        if (query.getDataflow() == null) {
            throw new IllegalArgumentException("A REST query requires a dataflow to be set - no dataflow found for query");
        }
        DataflowBean dataflow = query.getDataflow();
        sb.append(dataflow.getAgencyId());
        sb.append(",");
        sb.append(dataflow.getId());
        sb.append(",");
        sb.append(dataflow.getVersion());
        sb.append("/");
        HashMap<String, Set> selections = new HashMap<String, Set>();
        Date dateFrom = null;
        Date dateTo = null;
        if (query.hasSelections()) {
            DataQuerySelectionGroup dqsg = (DataQuerySelectionGroup)query.getSelectionGroups().get(0);
            if (dqsg.getDateFrom() != null) {
                dateFrom = dqsg.getDateFrom().getDate();
            }
            if (dqsg.getDateTo() != null) {
                dateTo = dqsg.getDateTo().getDate();
            }
            for (DataQuerySelection currentSelection : dqsg.getSelections()) {
                selections.put(currentSelection.getComponentId(), currentSelection.getValues());
            }
        }
        if (selections.size() == 0) {
            sb.append("ALL");
        } else {
            String concatPeriod = "";
            for (DimensionBean dim : keyFamily.getDimensions(new SDMX_STRUCTURE_TYPE[]{SDMX_STRUCTURE_TYPE.DIMENSION})) {
                sb.append(concatPeriod);
                String conceptId = dim.getId();
                if (selections.containsKey(conceptId)) {
                    String concatPlus = "";
                    for (String currentSelection : (Set)selections.get(conceptId)) {
                        sb.append(concatPlus);
                        sb.append(currentSelection);
                        concatPlus = "+";
                    }
                }
                concatPeriod = ".";
            }
        }
        String providerAgency = null;
        String providerId = null;
        if (query.getDataProvider() != null) {
            for (DataProviderBean currentProvider : query.getDataProvider()) {
                providerAgency = providerAgency != null && !providerAgency.equals(currentProvider.getMaintainableParent().getAgencyId()) ? "*" : currentProvider.getMaintainableParent().getAgencyId();
                if (providerId != null && !providerId.equals(currentProvider.getId())) {
                    providerId = "all";
                    continue;
                }
                providerId = currentProvider.getId();
            }
        }
        if (!"all".equals(providerId)) {
            if (!"all".equals(providerAgency)) {
                sb.append("/" + providerAgency + "," + providerId + "/");
            } else {
                sb.append("/" + providerId + "/");
            }
        } else {
            sb.append("/all/");
        }
        boolean firstAppend = true;
        if (query.getFirstNObservations() != null) {
            this.appendParam(firstAppend, "firstNObservations", query.getFirstNObservations(), sb);
            firstAppend = false;
        }
        if (query.getLastNObservations() != null) {
            this.appendParam(firstAppend, "lastNObservations", query.getLastNObservations(), sb);
            firstAppend = false;
        }
        if (query.getDataQueryDetail() != null) {
            this.appendParam(firstAppend, "detail", query.getDataQueryDetail().getRestParam(), sb);
            firstAppend = false;
        }
        if (dateFrom != null) {
            this.appendParam(firstAppend, "startPeriod", DateUtil.formatDate((Date)dateFrom), sb);
            firstAppend = false;
        }
        if (dateTo != null) {
            this.appendParam(firstAppend, "endPeriod", DateUtil.formatDate((Date)dateTo), sb);
            firstAppend = false;
        }
        return sb.toString();
    }

    private void appendParam(boolean firstAppend, String param, Object value, StringBuilder sb) {
        if (firstAppend) {
            sb.append("?");
        } else {
            sb.append("&");
        }
        sb.append(param + "=" + value);
    }
}

