package org.gcube.portlets.admin.software_upload_wizard.server.softwaremanagers.maven.deploy;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;

import org.gcube.portlets.admin.software_upload_wizard.server.logging.InjectLogger;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.maven.IMavenRepositoryInfo;
import org.slf4j.Logger;

public class ConsoleMavenDeployer implements IMavenDeployer {

	@InjectLogger
	Logger logger;

	public void deploy(IMavenRepositoryInfo repositoryInfo, File archiveFile,
			File pomFile) throws Exception {
		this.deploy(repositoryInfo, archiveFile, pomFile, true);
	}

	@Override
	public void deploy(IMavenRepositoryInfo repositoryInfo, File archiveFile,
			File pomFile, boolean generatePom) throws Exception {
		deploy(repositoryInfo, archiveFile, pomFile, generatePom, null);

	}

	@Override
	public void deploy(IMavenRepositoryInfo repositoryInfo, File archiveFile,
			File pomFile, boolean generatePom, String classifier)
			throws Exception {
		logger.debug("Deploying artifact on maven repository.");
		List<String> args = new LinkedList<String>();
		args.add("mvn");
		
		//Execute mvn command in batch mode
		args.add("-B");		
		
		args.add("deploy:deploy-file");

		args.add("-Durl=" + repositoryInfo.getUrl());

		args.add("-DrepositoryId=" + repositoryInfo.getId());

		args.add("-Dfile=" + archiveFile.getAbsolutePath());

		args.add("-DpomFile=" + pomFile.getAbsolutePath());

		if (!generatePom)
			args.add("-DgeneratePom=false");

		if (classifier!=null && !classifier.isEmpty())
			args.add("-Dclassifier="+classifier);

		logger.trace("Executing maven command with args: " + args);

		ProcessBuilder processBuilder = new ProcessBuilder(args);

		processBuilder.redirectErrorStream(true);

		Process process = processBuilder.start();

		String commandOutput = "";
		
		InputStream inputStream = process.getInputStream();
		InputStreamReader isr = new InputStreamReader(inputStream);
		BufferedReader br = new BufferedReader(isr);
		String line;
		while ((line = br.readLine()) != null) {
			commandOutput += line + "\n";
			logger.trace(line);
		}

		int code = process.waitFor();

		logger.trace("Maven command return code: " + code);

		if (code != 0) {
			logger.error("An error occurred while deploying an artifact on a maven repository, mvn command output follows:\n" + commandOutput);
			throw new Exception(
					"Maven deploy error.");
		}
		logger.debug("Maven artifact uploaded succesfully");
	}

}
