/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.taskmanager.client.ui.utils;

import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    public static List<String> getDeployedTasks(String descrXml) {
        ArrayList<String> taskNames = new ArrayList<String>();
        Document taskDom = XMLParser.parse((String)descrXml);
        XMLParser.removeWhitespace((Node)taskDom);
        NodeList tasks = taskDom.getElementsByTagName("Task");
        for (int i = 0; i < tasks.getLength(); ++i) {
            Node task = tasks.item(i);
            NodeList taskChildren = task.getChildNodes();
            for (int j = 0; j < taskChildren.getLength(); ++j) {
                Node child = taskChildren.item(j);
                if (child.getNodeType() != 1 || !child.getNodeName().equals("name")) continue;
                taskNames.add(child.getFirstChild().getNodeValue());
            }
        }
        return taskNames;
    }

    public static String getError(String descrXml) {
        String error = "no errors";
        Document taskDom = XMLParser.parse((String)descrXml);
        XMLParser.removeWhitespace((Node)taskDom);
        if (taskDom.getElementsByTagName("Error").getLength() > 0) {
            Node task = taskDom.getElementsByTagName("Error").item(0);
            error = task.getFirstChild().getNodeValue();
        }
        return error;
    }

    public static String getLog(String descrXml) {
        String log = "no logging";
        Document taskDom = XMLParser.parse((String)descrXml);
        XMLParser.removeWhitespace((Node)taskDom);
        if (taskDom.getElementsByTagName("Log").getLength() > 0) {
            Node task = taskDom.getElementsByTagName("Log").item(0);
            log = task.getFirstChild().getNodeValue();
        }
        return log;
    }

    public static String getOutput(String descrXml) {
        String output = "";
        Document taskDom = XMLParser.parse((String)descrXml);
        XMLParser.removeWhitespace((Node)taskDom);
        NodeList tasks = taskDom.getElementsByTagName("Outputs");
        for (int i = 0; i < tasks.getLength(); ++i) {
            Node task = tasks.item(i);
            NodeList taskChildren = task.getChildNodes();
            for (int j = 0; j < taskChildren.getLength(); ++j) {
                Node child = taskChildren.item(j);
                if (child.getNodeType() != 1 || !child.getNodeName().equals("entries")) continue;
                output = output + "\n" + child.getChildNodes();
            }
        }
        if (output.equals("")) {
            output = "no output";
        }
        return output;
    }

    public static String getSampleInput() {
        return "\t\t<Specify Map of Task Parameters in JSON syntax>\n\t\t\t(http://json.org)\n\n\n\ne.g. plugin advertises:\n\n\t<sampleInput>\n\t\t<name>parameter1</name>\n\t\t<description>A simple input</description>\n\t\t<value xsi:type=\"xsd:string\">sample</value>\n\t</sampleInput>\n\nyou write:\n\n\t{\"parameter1\":\"hello\"}";
    }

    public static String getTaskName(String taskDescrXml) {
        String taskName = null;
        Document taskDom = XMLParser.parse((String)taskDescrXml);
        XMLParser.removeWhitespace((Node)taskDom);
        Node task = taskDom.getElementsByTagName("name").item(0);
        taskName = task.getFirstChild().getNodeValue().toString();
        return taskName;
    }
}

