/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.taskmanager.server;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.types.URI;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.portlets.admin.taskmanager.client.model.Engines;
import org.gcube.portlets.admin.taskmanager.client.model.Tasks;
import org.gcube.portlets.admin.taskmanager.client.model.faults.ExecutorPortletException;
import org.gcube.portlets.admin.taskmanager.client.model.faults.MalformedResultException;
import org.gcube.portlets.admin.taskmanager.client.model.faults.QueryException;
import org.gcube.portlets.admin.taskmanager.client.model.faults.UnrecoverableException;
import org.gcube.vremanagement.executor.stubs.ExecutorCall;
import org.gcube.vremanagement.executor.stubs.TaskCall;
import org.gcube.vremanagement.executor.stubs.Utils;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.encoding.SerializationException;
import org.globus.wsrf.impl.SimpleResourceKey;

public class Queries {
    public List<Engines> getEngines(String scope) {
        ArrayList<Engines> engines = new ArrayList<Engines>();
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            WSResourceQuery wsquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            wsquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//gc:ServiceName", "Executor")});
            for (RPDocument d : client.execute((ISQuery)wsquery, GCUBEScope.getScope((String)scope))) {
                if (!d.getEndpoint().getAddress().getPath().endsWith("gcube/vremanagement/executor/engine")) continue;
                engines.add(new Engines(d.getEndpoint().getAddress().toString(), d.getRIID(), d.getEndpoint().getAddress().getHost() + ":" + d.getEndpoint().getAddress().getPort(), d.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return engines;
    }

    public List<Tasks> queryForTasks(String scope, String[] ids) throws UnrecoverableException, QueryException, MalformedResultException {
        ArrayList<Tasks> tasks = new ArrayList<Tasks>();
        ISClient client = null;
        WSResourceQuery wsquery = null;
        try {
            client = (ISClient)GHNContext.getImplementation(ISClient.class);
            wsquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
        }
        catch (Exception e) {
            throw new UnrecoverableException("back-end installation is corrupt");
        }
        wsquery.addGenericCondition("ends-with($outer/Source,'gcube/vremanagement/executor/task')");
        if (ids.length > 0) {
            String idConditionFormat = "$outer/SourceKey eq '%1$s'";
            StringBuilder builder = new StringBuilder();
            for (String id : ids) {
                String idCondition = String.format(idConditionFormat, id);
                builder.append(builder.length() == 0 ? idCondition : " or " + idCondition);
            }
            if (builder.length() > 0) {
                wsquery.addGenericCondition(builder.toString());
            }
        }
        List results = null;
        try {
            results = client.execute((ISQuery)wsquery, GCUBEScope.getScope((String)scope));
        }
        catch (ISException e) {
            throw new QueryException(e.getMessage());
        }
        for (RPDocument d : results) {
            try {
                String creationTime = (String)d.evaluate("/" + Utils.TASK_STARTED_RP.getLocalPart() + "/text()").get(0);
                String state = (String)d.evaluate("/" + Utils.TASK_STATE_RP.getLocalPart() + "/text()").get(0);
                StringWriter writer = new StringWriter();
                ObjectSerializer.serialize((Writer)writer, (Object)d.getEndpoint(), (QName)new QName("http://gcube-system.org/namespaces/vremanagement/executor", "task"));
                writer.toString();
                tasks.add(new Tasks(Integer.valueOf(0), null, d.getKey().getValue(), d.getEndpoint().getAddress().toString(), creationTime, state, d.getEndpoint().getAddress().getHost() + ":" + d.getEndpoint().getAddress().getPort(), d.getRIID(), d.toString()));
            }
            catch (Exception e) {
                if (ids.length != 1) continue;
                throw new MalformedResultException("could not extract required information from " + d.toString());
            }
        }
        return tasks;
    }

    public void stopTask(String epr, String resKey, String scope) throws ExecutorPortletException {
        TaskCall tcall = null;
        EndpointReferenceType endpoint = new EndpointReferenceType();
        try {
            endpoint.setAddress(new AttributedURI(epr));
        }
        catch (URI.MalformedURIException e1) {
            e1.printStackTrace();
        }
        ReferencePropertiesType props = new ReferencePropertiesType();
        SimpleResourceKey key = new SimpleResourceKey(new QName("http://gcube-system.org/namespaces/vremanagement/executor", "ResourceKey"), (Object)resKey);
        try {
            props.add((Object)key.toSOAPElement());
        }
        catch (SerializationException e1) {
            e1.printStackTrace();
        }
        endpoint.setProperties(props);
        System.out.println("endpoint: " + endpoint);
        try {
            tcall = new TaskCall(endpoint, GCUBEScope.getScope((String)scope), new GCUBESecurityManager[0]);
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            throw new ExecutorPortletException("invalid scope while creating a call to the task: " + e.getMessage());
        }
        catch (Exception e) {
            throw new ExecutorPortletException("call to the task failed: " + e.getMessage());
        }
        try {
            tcall.stop();
        }
        catch (GCUBEException e) {
            throw new ExecutorPortletException("task could not be stopped: " + e.getMessage());
        }
        catch (Exception e) {
            throw new ExecutorPortletException("task could not be stopped: " + e.getMessage());
        }
    }

    public void launchTask(String taskName, String epr, String input, String scope) {
        EndpointReferenceType endpoint = new EndpointReferenceType();
        try {
            endpoint.setAddress(new AttributedURI(epr));
        }
        catch (URI.MalformedURIException e2) {
            e2.printStackTrace();
        }
        ExecutorCall call = null;
        try {
            call = new ExecutorCall(taskName, GCUBEScope.getScope((String)scope), new GCUBESecurityManager[0]);
            System.out.println("exec call created");
        }
        catch (GCUBEScope.MalformedScopeExpressionException e1) {
            e1.printStackTrace();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        call.setEndpointReference(endpoint);
        System.out.println("endpoint set");
        ObjectMapper mapper = new ObjectMapper();
        Map m = null;
        try {
            m = (Map)mapper.readValue(input, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            System.out.println("map created");
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            call.launch(m);
            System.out.println("task launched");
        }
        catch (GCUBEException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

