/**
 * 
 */
package org.gcube.portlets.user.gcubegisviewer.client;

import org.gcube.portlets.user.gcubegisviewer.client.event.HasSaveHandlers;
import org.gcube.portlets.user.gcubegisviewer.client.event.SaveEvent;
import org.gcube.portlets.user.gisviewer.client.GisViewerSaveHandler;
import org.gcube.portlets.user.workspace.lighttree.client.ItemType;
import org.gcube.portlets.user.workspace.lighttree.client.event.DataLoadEvent;
import org.gcube.portlets.user.workspace.lighttree.client.event.DataLoadHandler;
import org.gcube.portlets.user.workspace.lighttree.client.event.PopupEvent;
import org.gcube.portlets.user.workspace.lighttree.client.event.PopupHandler;
import org.gcube.portlets.user.workspace.lighttree.client.save.WorkspaceLightTreeSavePopup;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class GCubeGisViewerSaveHandler implements GisViewerSaveHandler {
	
	protected static GCubeGisViewerServiceAsync service = (GCubeGisViewerServiceAsync)GWT.create(GCubeGisViewerService.class);		
	protected HasSaveHandlers hasSaveHandlers;
	
	/**
	 * @param hasSaveHandlers the hasSaveHandlers to set
	 */
	public void setHasSaveHandlers(HasSaveHandlers hasSaveHandlers) {
		this.hasSaveHandlers = hasSaveHandlers;
	}

	@Override
	public void saveLayerImage(final String name, final String contentType, final String url) {
		GWT.log("saveLayerImage name: "+name+" contentType: "+contentType+" url: "+url);
		
		WorkspaceLightTreeSavePopup popup = new WorkspaceLightTreeSavePopup("Select where to save the Layer item", true, name);

		popup.addStyleName("z_index_1200");
		popup.setSelectableTypes(ItemType.FOLDER, ItemType.ROOT);

		popup.center();

		popup.addPopupHandler(new PopupHandler() {
			
			public void onPopup(PopupEvent event) {
				if (!event.isCanceled()){
					org.gcube.portlets.user.workspace.lighttree.client.Item item = event.getSelectedItem();
					final String name = event.getName();
					SaveEvent.fireSave(hasSaveHandlers, name, contentType, url);
					service.saveLayerItem(name, contentType, url, item.getId(), new AsyncCallback<Void>() {
						
						@Override
						public void onSuccess(Void result) {
							SaveEvent.fireSaveSuccess(hasSaveHandlers, name, contentType, url);
						}
						
						@Override
						public void onFailure(Throwable caught) {
							SaveEvent.fireSaveFailure(hasSaveHandlers, name, contentType, url, caught);
						}
					});	
					
				}
			}

		});
		popup.addDataLoadHandler(new DataLoadHandler() {
			
			@Override
			public void onDataLoad(DataLoadEvent event) {
				if (event.isFailed())GWT.log("Workspace loading failure", event.getCaught());
			}
		});
		popup.setText(name);
		popup.show();	
		
		
	}

	@Override
	public void saveMapImage(String name, String contentType, String url) {
		// TODO Auto-generated method stub
		
	}
}
