/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.management.quota.manager.util;

import java.util.Iterator;
import java.util.List;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryService {
    private String basePath = null;
    private static Logger logger = LoggerFactory.getLogger(DiscoveryService.class);
    private static final String RUNTIME_RESOURCE_NAME = "SocialNetworking";
    private static final String CATEGORY = "Portal";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryService(String context) {
        if (context == null || context.isEmpty()) {
            throw new IllegalArgumentException("A valid context is needed to discover the service");
        }
        String oldContext = ScopeProvider.instance.get();
        ScopeProvider.instance.set(context);
        try {
            List resources = this.getConfigurationFromIS();
            if (resources.size() == 0) {
                logger.error("There is no Runtime Resource having name SocialNetworking and Category Portal in this scope.");
                throw new Exception("There is no Runtime Resource having name SocialNetworking and Category Portal in this scope.");
            }
            for (ServiceEndpoint res : resources) {
                Iterator accessPointIterator = res.profile().accessPoints().iterator();
                if (!accessPointIterator.hasNext()) continue;
                ServiceEndpoint.AccessPoint accessPoint = (ServiceEndpoint.AccessPoint)accessPointIterator.next();
                this.basePath = accessPoint.address();
            }
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such service endpoint information!", (Throwable)e);
        }
        finally {
            if (oldContext != null && !oldContext.equals(context)) {
                ScopeProvider.instance.set(oldContext);
            }
        }
    }

    private List<ServiceEndpoint> getConfigurationFromIS() throws Exception {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'SocialNetworking'");
        query.addCondition("$resource/Profile/Category/text() eq 'Portal'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List toReturn = client.submit((Query)query);
        return toReturn;
    }

    public String getBasePath() {
        return this.basePath;
    }
}

