/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.management.quota.manager.check;

import java.util.Timer;
import java.util.TimerTask;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resource.management.quota.manager.check.QuotaCheckTask;
import org.gcube.resource.management.quota.manager.check.QuotaUsage;
import org.gcube.resource.management.quota.manager.persistence.QuotaDBPersistence;
import org.gcube.resource.management.quota.manager.util.Constants;
import org.gcube.resource.management.quota.manager.util.DiscoveryConfiguration;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyAppManager
implements ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(MyAppManager.class);
    ApplicationContext ctx = ContextProvider.get();
    Timer timer = null;
    public String dbName;
    private QuotaUsage quotaUsage;
    private QuotaDBPersistence quotaDbPersistence;

    public void onInit() {
        logger.info("QuotaCheckTask on init");
        String token = SecurityTokenProvider.instance.get();
        String context = ScopeProvider.instance.get();
        logger.info("QuotaCheckTask on discovery");
        DiscoveryConfiguration discoveryCheck = new DiscoveryConfiguration(context);
        logger.info("QuotaCheckTask DiscoveryConfiguration complete");
        this.dbName = discoveryCheck.getDbname();
        this.quotaDbPersistence = new QuotaDBPersistence(discoveryCheck.getDatabasePath(), discoveryCheck.getDbname(), discoveryCheck.getUsernameDb(), discoveryCheck.getPwdnameDb());
        this.quotaUsage = new QuotaUsage(discoveryCheck);
        AccountingPersistenceQuery apq = AccountingPersistenceQueryFactory.getInstance();
        QuotaCheckTask task = new QuotaCheckTask(context, token, this.quotaUsage, this.quotaDbPersistence, apq);
        Integer refreshTimeQuotaConfiguration = discoveryCheck.getRefreshTimeQuota();
        Long refreshTimeQuota = refreshTimeQuotaConfiguration == 0 ? Constants.TIME_SCHEDULE_CHECK : Long.valueOf(refreshTimeQuotaConfiguration * 60 * 1000);
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)task, Constants.DELAY_SCHEDULE_CHECK, (long)refreshTimeQuota);
        logger.info("QuotaCheckTask started in context {}", (Object)context);
        logger.info("QuotaCheckTask schedule task on:{} milliseconds", (Object)refreshTimeQuota);
        logger.info("QuotaCheckTask notifierUser :{} notifierAdmin:{}", (Object)discoveryCheck.getNotifierUser(), (Object)discoveryCheck.getNotifierAdmin());
    }

    public void onShutdown() {
        this.timer.cancel();
    }

    public QuotaUsage getQuotaUsage() {
        return this.quotaUsage;
    }

    public QuotaDBPersistence getQuotaDbPersistence() {
        return this.quotaDbPersistence;
    }
}

