/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.contexts;

import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.KeyData;
import org.gcube.common.vremanagement.deployer.impl.state.DeployerResource;

public class RIConsumer
extends GCUBEResource.ResourceConsumer {
    protected final GCUBELog logger = new GCUBELog(RIConsumer.class);
    private GCUBEService service;
    private DeployerResource resource;

    protected RIConsumer(GCUBEService service, DeployerResource resource) {
        this.service = service;
        this.resource = resource;
    }

    protected void onAddScope(GCUBEResource.AddScopeEvent event) {
        super.onAddScope(event);
        this.logger.trace((Object)("New detected scope(s) for ServiceClass=" + this.service.getServiceClass() + ",ServiceName=" + this.service.getServiceName() + ",ServiceVersion=" + this.service.getVersion()));
        for (Package servicePackage : this.service.getPackages()) {
            try {
                BaseTypedPackage base = this.getPackage(servicePackage);
                this.addScopeToDeps(base.getKey(), this.toSet((GCUBEScope[])event.getPayload()));
            }
            catch (DeployerResource.NoSuchPackageException e) {
                this.logger.trace((Object)("Package not found: " + e.getMessage()));
            }
        }
    }

    protected void onRemoveScope(GCUBEResource.RemoveScopeEvent event) {
        super.onRemoveScope(event);
        this.logger.trace((Object)("Removed scope(s) for ServiceClass=" + this.service.getServiceClass() + ",ServiceName=" + this.service.getServiceName() + ",ServiceVersion=" + this.service.getVersion()));
        for (Package servicePackage : this.service.getPackages()) {
            try {
                BaseTypedPackage base = this.getPackage(servicePackage);
                this.removeScopeFromDeps(base.getKey(), this.toSet((GCUBEScope[])event.getPayload()));
            }
            catch (DeployerResource.NoSuchPackageException e) {
                this.logger.trace((Object)("Package not found: " + e.getMessage()));
            }
        }
    }

    private void removeScopeFromDeps(KeyData key, Set<GCUBEScope> scopes) {
        try {
            BaseTypedPackage tpackage = this.resource.getPackage(key);
            this.logger.trace((Object)("Removing scopes from package " + tpackage.getKey().toString()));
            tpackage.removeScopes(scopes);
            for (KeyData dep : tpackage.getDependencies()) {
                this.removeScopeFromDeps(dep, scopes);
            }
        }
        catch (DeployerResource.NoSuchPackageException e) {
            this.logger.warn((Object)("Unable to remove the scopes from the package: " + e.getMessage()));
        }
    }

    private void addScopeToDeps(KeyData key, Set<GCUBEScope> scopes) {
        try {
            BaseTypedPackage tpackage = this.resource.getPackage(key);
            this.logger.trace((Object)("Adding scopes to package " + tpackage.getKey().toString()));
            tpackage.setScopes(scopes);
            for (KeyData dep : tpackage.getDependencies()) {
                this.addScopeToDeps(dep, scopes);
            }
        }
        catch (DeployerResource.NoSuchPackageException e) {
            this.logger.warn((Object)("Unable to add the new scopes to the package: " + e.getMessage()));
        }
    }

    private BaseTypedPackage getPackage(Package servicePackage) throws DeployerResource.NoSuchPackageException {
        KeyData base = new KeyData(this.service.getServiceClass(), this.service.getServiceName(), this.service.getVersion(), servicePackage.getName(), servicePackage.getVersion());
        return this.resource.getPackage(base);
    }

    private Set<GCUBEScope> toSet(GCUBEScope[] scopes) {
        HashSet<GCUBEScope> retScopes = new HashSet<GCUBEScope>();
        for (GCUBEScope scope : scopes) {
            retScopes.add(scope);
        }
        return retScopes;
    }
}

