package org.gcube.vremanagement.executor.stubs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.plugins.GCUBEPluginContext.TypeMapping;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.calls.WSCall;

/**
 * Base class for high-level interactions with the service.
 * @author Fabio Simeoni (University of Strathclyde)
 *
 */
public abstract class BaseCall extends WSCall {

	/** Format for query condition on task name. */
	private static String conditionsFormat = "some $task in $result/child::*[local-name()='Task'] satisfies ($task/child::*[local-name()='name']/string() eq '%1$s'" +
			"%2$s)";
	/** Format for query condition on task properties. */
	private static String propertyConditionFormat = " and (some $prop in $task/child::*[local-name()='property'] satisfies ($prop/child::*[local-name()='name']/string() eq '%1$s' and " +
			"$prop/child::*[local-name()='value']/string() eq '%2$s'))";
		
	/** The name of the task to launch */
	protected String taskName;
	
	/**Name and value of properties to use as filter for task discovery.*/
	protected Map<String,String> properties = new HashMap<String,String>();
	
	/**The type mappings required by the task.*/
	protected List<TypeMapping> mappings = new ArrayList<TypeMapping>();

	
	protected BaseCall(String taskName, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
		this(scope,securityManager);
		this.taskName=taskName;
	}
	
	protected BaseCall(GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
		super(scope,securityManager);
	}
	
	/**{@inheritDoc}*/ 
	protected String getServiceClass() {return Utils.SERVICE_CLASS;}
	
	/**{@inheritDoc}*/ 
	protected String getServiceName() {return Utils.SERVICE_NAME;}
	
	/**Sets the name and value of a task property to use in the query for the best-effort strategy..
	 * @param name the name.*/
	public void setTaskProperty(String name,String value) {this.properties.put(name, value);}

	//flags if query has already been prepared.
	private boolean isQueryPrepared = false;
	
	/**{@inheritDoc}*/
	@Override public synchronized void setQuery(WSResourceQuery query) {
		super.setQuery(query);
		isQueryPrepared=false;
	}
	
	/**{@inheritDoc}*/
	@Override public synchronized WSResourceQuery getQuery() {
		WSResourceQuery query = super.getQuery(); 
		if (isQueryPrepared) return query;
		StringBuilder propertyConditions = new StringBuilder();
		for (Map.Entry<String,String> entry : this.properties.entrySet()) 
			propertyConditions.append(String.format(propertyConditionFormat, entry.getKey(),entry.getValue()));
		query.addGenericCondition(String.format(conditionsFormat,taskName,propertyConditions.toString()));	
		isQueryPrepared=true;
		logger.trace(query.getExpression());
		return query;
	}
	
}
