package org.gcube.vremanagement.executor.stubs;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.plugins.GCUBEPluginContext.TypeMapping;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.container.ServiceContainer;
import org.globus.wsrf.container.ServiceContainerCollection;

/**
 * A central registry of type mappings.
 * @author Fabio Simeoni (University of Strathclyde)
 */
public class MappingRegistry {

	private static final String GLOBUS_LOCATION = "GLOBUS_LOCATION";

	/** Class logger */
	static private GCUBELog logger = new GCUBEClientLog(MappingRegistry.class);

	/**The {@link NotificationConsumerManager} shared by all {@link TaskMonitor monitors}.*/
	static NotificationConsumerManager manager = NotificationConsumerManager.getInstance();

	/** The client mapping registry. */
	private static TypeMappingRegistry registry = ContainerConfig.getClientEngine().getTypeMappingRegistry();
	
	/** The consumer mapping registry. */
	private static TypeMappingRegistry consumerRegistry;
	
	/**The type mappings required by the task.*/
	static private List<TypeMapping> mappings = new ArrayList<TypeMapping>();

	static {
		
		if (System.getProperty(GLOBUS_LOCATION)==null) //convenience
			System.setProperty(GLOBUS_LOCATION, GHNContext.getContext().getLocation());
		
		try{
			manager.startListening();
			
			ServiceContainer container  = ServiceContainerCollection.get(manager.getURL().toString());
			WSDDEngineConfiguration engineConfig = (WSDDEngineConfiguration) container.getEngine().getConfig(); 
			SOAPService service = engineConfig.getDeployment().getService(new QName("NotificationConsumerService"));
			consumerRegistry = service.getTypeMappingRegistry();
			
		}catch(Exception e) {
			logger.error("could not start the notification framework",e);
		}
	}

	/**
	 * Adds one or more type mappings required by the task.
	 * @param typeMappings the mappings
	 */
	public static void register(TypeMapping ... typeMappings) {
		for (TypeMapping m : typeMappings) {
			mappings.add(m);
			registry.getDefaultTypeMapping().register(m.clazz,m.qname,m.sFactory,m.dfactory);
			consumerRegistry.getTypeMapping("").register(m.clazz,m.qname,m.sFactory,m.dfactory);
		}
	}
}
