/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.brokerage;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.brokerage.Broker;
import org.gcube.vremanagement.resourcemanager.impl.reporting.Session;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedSoftware;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.VirtualNode;

public class InternalBroker
implements Broker {
    private final GCUBELog logger = new GCUBELog((Object)this);
    private ScopeState scopeState;
    private String[] suggestedGHNs = new String[0];
    private int nodewalker = 0;

    @Override
    public void initialize(ScopeState scopeState) throws Exception {
        this.scopeState = scopeState;
    }

    @Override
    public void makePlan(Session session, Set<ScopedDeployedSoftware> services, String[] suggestedGHNs) throws Exception {
        this.suggestedGHNs = suggestedGHNs;
        for (ScopedDeployedSoftware service : services) {
            try {
                this.assignTargetGHN(service);
            }
            catch (VirtualNode.NoGHNFoundException e1) {
                this.logger.error((Object)(service.getSourcePackage() + "Unable to find a suitable target gHN"));
                service.setStatus(ScopedResource.STATUS.LOST);
                service.setErrorMessage("Unable to find a suitable target gHN");
                throw new IOException(service.getSourcePackage() + " - unable to find a suitable target gHN for this service");
            }
        }
    }

    private void assignTargetGHN(ScopedDeployedSoftware service) throws VirtualNode.NoGHNFoundException {
        if (service.getSourcePackage().getGHNName() != null && service.getSourcePackage().getGHNName().compareToIgnoreCase("") != 0) {
            this.logger.info((Object)("A specific GHN (" + service.getSourcePackage().getGHNName() + ") has been requested by the caller for " + service));
            VirtualNode node = this.scopeState.getNode(service.getSourcePackage().getGHNName());
            node.setWorkingScope(this.scopeState.getScope());
            node.isNotWorking();
            service.scheduleDeploy(node);
        } else if (this.suggestedGHNs.length > 0) {
            this.logger.info((Object)("A set of target GHNs " + Arrays.toString(this.suggestedGHNs) + " has been requested by the caller for " + service));
            VirtualNode node = this.scopeState.getNode(this.suggestedGHNs[this.nodewalker++ % this.suggestedGHNs.length]);
            node.setWorkingScope(this.scopeState.getScope());
            node.isNotWorking();
            service.scheduleDeploy(node);
        } else {
            this.logger.info((Object)"no GHN has been specified as explicit target");
            throw new VirtualNode.NoGHNFoundException("No GHN was assigned to the service from the caller");
        }
    }

    @Override
    public void sendFeedback(Session session) throws Exception {
    }
}

