/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.state;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.runninginstance.Endpoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResourceFactory;
import org.gcube.vremanagement.resourcemanager.impl.state.ProfileDate;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class PublishedScopeResource {
    protected GCUBELog logger = new GCUBELog((Object)this);
    private GCUBEGenericResource resource;
    private PublishedResourceList publishedResourceList;
    private GCUBEScope scope;
    private static final String NS = "";
    private String manager = "";
    private String designer = "";
    private String service = "";
    private Date startTime = null;
    private Date endTime = null;
    private boolean securityEnabled = false;
    private boolean loaded = false;
    private static Map<GCUBEScope, PublishedScopeResource> cache = new HashMap<GCUBEScope, PublishedScopeResource>();

    public void reload() throws Exception {
        try {
            this.publishedResourceList = new PublishedResourceList();
            this.load();
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to reload the Scope Resource");
            throw e;
        }
    }

    private PublishedScopeResource(GCUBEScope scope) throws Exception {
        this.scope = scope;
        this.publishedResourceList = new PublishedResourceList();
        this.service = ((Endpoint)ServiceContext.getContext().getInstance().getAccessPoint().getRunningInstanceInterfaces().getEndpoint().get(0)).getValue();
        try {
            this.resource = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
        }
        catch (Exception e) {
            throw new Exception("Unable to create resource to publish for " + scope.toString());
        }
    }

    public static PublishedScopeResource getResource(GCUBEScope scope) throws Exception {
        if (!cache.containsKey(scope)) {
            cache.put(scope, new PublishedScopeResource(scope));
        }
        return cache.get(scope);
    }

    public void addResource(ScopedResource resource) throws Exception {
        this.publishedResourceList.add(resource.getId(), resource.getType(), resource.getJointTime(), resource.getHostedOn());
        resource.setStatus(ScopedResource.STATUS.PUBLISHED);
    }

    public void removeResource(ScopedResource resource) throws Exception {
        this.publishedResourceList.remove(resource.getId(), resource.getType());
        resource.setStatus(ScopedResource.STATUS.UNPUBLISHED);
    }

    public String toString() {
        try {
            this.resource.setBody(this.prepareBody());
            StringWriter ret = new StringWriter();
            this.resource.store((Writer)ret);
            return ret.toString();
        }
        catch (Exception e) {
            this.logger.error((Object)"Invalid Scope Resource serialization", (Throwable)e);
            return NS;
        }
    }

    public GCUBEScope getScope() {
        return this.scope;
    }

    public GCUBEScope.Type getType() {
        return this.scope.getType();
    }

    public void setOption(String name, String value) throws Exception {
        if (value == null) {
            return;
        }
        this.logger.debug((Object)("setting option " + name));
        try {
            if (name.compareToIgnoreCase("DESIGNER") == 0) {
                this.designer = value;
            } else if (name.compareToIgnoreCase("MANAGER") == 0 || name.compareToIgnoreCase("CREATOR") == 0) {
                this.manager = value;
            } else if (name.compareToIgnoreCase("ENDTIME") == 0) {
                this.endTime = ProfileDate.fromXMLDateAndTime(value);
            } else if (name.compareToIgnoreCase("STARTTIME") == 0) {
                this.startTime = ProfileDate.fromXMLDateAndTime(value);
            } else if (name.compareToIgnoreCase("DESCRIPTION") == 0) {
                this.resource.setDescription(value);
            } else if (name.compareToIgnoreCase("DISPLAYNAME") == 0) {
                this.resource.setName(value);
            } else if (name.compareToIgnoreCase("SECURITYENABLED") == 0) {
                this.securityEnabled = Boolean.valueOf(value);
            }
        }
        catch (ParseException e) {
            throw new Exception("Unable to parse option " + name);
        }
    }

    public synchronized void publish() throws Exception {
        this.logger.trace((Object)"publish method invokation ");
        this.resource.setBody(this.prepareBody());
        this.logger.trace((Object)("Publishing Scope Resource: \n" + this.toString()));
        ISPublisher publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
        if (this.loaded) {
            this.logger.trace((Object)("update resource by ISPublisher: " + this.resource + " scope " + this.scope + " context  " + (Object)((Object)ServiceContext.getContext())));
            publisher.updateGCUBEResource((GCUBEResource)this.resource, this.scope, (GCUBESecurityManager)ServiceContext.getContext());
        } else {
            this.logger.trace((Object)("register resource by ISPublisher: res " + this.resource + " scope " + this.scope + " context  " + (Object)((Object)ServiceContext.getContext())));
            publisher.registerGCUBEResource((GCUBEResource)this.resource, this.scope, (GCUBESecurityManager)ServiceContext.getContext());
            this.loaded = true;
        }
    }

    public synchronized void dismiss() throws Exception {
        this.resource.setBody(this.prepareBody());
        ISPublisher publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
        publisher.removeGCUBEResource(this.resource.getID(), this.resource.getType(), this.scope, (GCUBESecurityManager)ServiceContext.getContext());
        cache.remove(this.getScope());
    }

    private String prepareBody() throws IOException {
        StringWriter body = new StringWriter();
        KXmlSerializer serializer = new KXmlSerializer();
        serializer.setOutput((Writer)body);
        try {
            serializer.startDocument("UTF-8", Boolean.valueOf(true));
            serializer.startTag(NS, "Scope").text(this.scope.toString()).endTag(NS, "Scope");
            serializer.startTag(NS, "Service").text(this.service).endTag(NS, "Service");
            serializer.startTag(NS, "Manager").text(this.getManager()).endTag(NS, "Manager");
            serializer.startTag(NS, "Designer").text(this.getDesigner()).endTag(NS, "Designer");
            if (this.startTime == null) {
                this.startTime = Calendar.getInstance().getTime();
            }
            serializer.startTag(NS, "StartTime").text(ProfileDate.toXMLDateAndTime(this.startTime)).endTag(NS, "StartTime");
            if (this.endTime != null) {
                serializer.startTag(NS, "EndTime").text(ProfileDate.toXMLDateAndTime(this.endTime)).endTag(NS, "EndTime");
            }
            serializer.startTag(NS, "SecurityEnabled").text(String.valueOf(this.securityEnabled)).endTag(NS, "SecurityEnabled");
            this.publishedResourceList.store(serializer);
        }
        catch (Exception e) {
            this.logger.error((Object)"The Scope Resource does not have a valid serialisation", (Throwable)e);
            throw new IOException("The Scope Resource does not have a valid serialisation");
        }
        finally {
            body.close();
        }
        return body.toString();
    }

    public String getManager() {
        return this.manager != null ? this.manager : NS;
    }

    public String getDesigner() {
        return this.designer != null ? this.designer : NS;
    }

    public String getDescription() {
        return this.resource.getDescription() != null ? this.resource.getDescription() : NS;
    }

    public String getDisplayName() {
        return this.resource.getName() != null ? this.resource.getName() : NS;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    private void parseBody(String body) throws Exception {
        block13: {
            KXmlParser parser = new KXmlParser();
            parser.setInput((Reader)new BufferedReader(new StringReader(body)));
            try {
                while (true) {
                    switch (parser.next()) {
                        case 2: {
                            if (parser.getName().equals("Creator")) {
                                this.manager = parser.nextText();
                                break;
                            }
                            if (parser.getName().equals("Designer")) {
                                this.designer = parser.nextText();
                                break;
                            }
                            if (parser.getName().equals("EndTime")) {
                                this.endTime = ProfileDate.fromXMLDateAndTime(parser.nextText());
                                break;
                            }
                            if (parser.getName().equals("StartTime")) {
                                this.startTime = ProfileDate.fromXMLDateAndTime(parser.nextText());
                                break;
                            }
                            if (parser.getName().equals("SecurityEnabled")) {
                                this.securityEnabled = Boolean.valueOf(parser.nextText());
                                break;
                            }
                            if (parser.getName().equals("ScopedRescources")) {
                                this.publishedResourceList.load(parser);
                                break;
                            }
                            parser.nextText();
                            break;
                        }
                        case 1: {
                            break block13;
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new Exception("Unable to parse the PublishedScopeResource body");
            }
        }
    }

    protected boolean load() {
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/SecondaryType", this.determineSecondaryType()), new AtomicCondition("/Profile/Body/Scope", this.scope.toString())});
            List results = client.execute((ISQuery)query, this.scope);
            if (results != null && results.size() > 0) {
                this.resource = (GCUBEGenericResource)results.get(0);
                this.parseBody(this.resource.getBody());
                this.loaded = true;
                this.logger.trace((Object)("Resource loaded from the IS: \n" + this.toString()));
                return true;
            }
            this.logger.warn((Object)("Unable to load the resource for " + this.scope.toString() + " from the IS"));
        }
        catch (Exception e) {
            this.logger.warn((Object)("Published resource for " + this.scope.toString() + " does not exist on the IS"), (Throwable)e);
        }
        return false;
    }

    private String determineSecondaryType() {
        if (this.scope.getType() == GCUBEScope.Type.VRE) {
            return "VRE";
        }
        if (this.scope.getType() == GCUBEScope.Type.VO) {
            return "VO";
        }
        return "INFRASTRUCTURE";
    }

    public boolean loaded() {
        return this.loaded;
    }

    public void to(ScopeState scopeState) {
        this.logger.debug((Object)"To: Filling the local scope state with the published state");
        scopeState.addResources(this.publishedResourceList.asScopedResources(scopeState));
        scopeState.setDesigner(this.getDesigner());
        scopeState.setManager(this.getManager());
        scopeState.setSecurity(this.isSecurityEnabled());
        scopeState.changeDescription(this.getDescription());
        scopeState.setEndTime(this.endTime);
        this.logger.trace((Object)("Setting the scope state to " + ProfileDate.toXMLDateAndTime(this.startTime)));
        scopeState.setStartTime(this.startTime);
        this.logger.trace((Object)("Scope state set to:" + ProfileDate.toXMLDateAndTime(scopeState.getStartTime())));
        scopeState.setName(this.getDisplayName());
    }

    public synchronized void loadFromLocalState(ScopeState scopeState) throws Exception {
        this.logger.debug((Object)("LoadFromLocalState: Loading the published state for " + this.scope.getName() + " from the local file system"));
        this.reload();
        this.publishedResourceList = new PublishedResourceList();
        this.synchBasicInfo(scopeState);
        for (ScopedResource resource : scopeState.getAllResources()) {
            this.addResource(resource);
        }
        if (this.scope.getType() == GCUBEScope.Type.VRE) {
            this.resource.setSecondaryType("VRE");
        } else if (this.scope.getType() == GCUBEScope.Type.VO) {
            this.resource.setSecondaryType("VO");
        } else {
            this.resource.setSecondaryType("INFRASTRUCTURE");
        }
        this.resource.addScope(new GCUBEScope[]{this.scope});
        this.toString();
    }

    public synchronized void synchWithLocalState(ScopeState scopeState) throws Exception {
        this.logger.debug((Object)"SynchWithLocalState: Synch the published state from the scope state");
        for (ScopedResource resource : scopeState.getAllResources()) {
            this.logger.debug((Object)("resource: " + resource.getId() + " with status " + (Object)((Object)resource.getStatus())));
            switch (resource.getStatus()) {
                case ADDED: {
                    this.addResource(resource);
                    break;
                }
                case REMOVED: {
                    this.removeResource(resource);
                    break;
                }
                case LOST: {
                    this.removeResource(resource);
                }
            }
        }
        this.synchBasicInfo(scopeState);
    }

    private void synchBasicInfo(ScopeState scopeState) throws Exception {
        this.logger.debug((Object)"Synchronizing basic info to publish");
        this.setOption("CREATOR", scopeState.getManager());
        this.setOption("DESIGNER", scopeState.getDesigner());
        this.setOption("DESCRIPTION", scopeState.getDescription());
        this.setOption("DISPLAYNAME", scopeState.getName());
        this.endTime = scopeState.getEndTime();
        this.startTime = scopeState.getStartTime();
        this.securityEnabled = scopeState.isSecurityEnabled();
    }

    class PublishedResourceList {
        private Set<Item> resources = Collections.synchronizedSet(new HashSet());
        private static final String RESOURCES_ELEMENT = "ScopedRescources";
        private static final String RESOURCE_ELEMENT = "ScopedRescource";

        PublishedResourceList() {
        }

        void add(String id, String type, Date time, String ... hostedOn) {
            this.resources.add(new Item(id, type, time, hostedOn));
        }

        void remove(String id, String type) {
            this.resources.remove(new Item(id, type, new String[0]));
        }

        Set<ScopedResource> asScopedResources(ScopeState state) {
            HashSet<ScopedResource> temp = new HashSet<ScopedResource>();
            for (Item item : this.resources) {
                try {
                    ScopedResource resource = ScopedResourceFactory.newResource(state.getScope(), item.id, item.type);
                    resource.setJointTime(item.timestamp);
                    if (item.hostedOn != null && item.hostedOn.compareTo(PublishedScopeResource.NS) != 0) {
                        resource.setHostedON(item.hostedOn);
                    }
                    temp.add(resource);
                }
                catch (Exception e) {
                    PublishedScopeResource.this.logger.error((Object)"Can't build the resource", (Throwable)e);
                }
            }
            return temp;
        }

        int getSize() {
            return this.resources.size();
        }

        void store(KXmlSerializer serializer) throws IOException {
            serializer.startTag(PublishedScopeResource.NS, RESOURCES_ELEMENT);
            for (Item item : this.resources) {
                serializer.startTag(PublishedScopeResource.NS, RESOURCE_ELEMENT);
                serializer.startTag(PublishedScopeResource.NS, "ResourceID").text(item.id).endTag(PublishedScopeResource.NS, "ResourceID");
                serializer.startTag(PublishedScopeResource.NS, "ResourceType").text(item.type).endTag(PublishedScopeResource.NS, "ResourceType");
                if (item.hostedOn != null && item.hostedOn.compareTo(PublishedScopeResource.NS) != 0) {
                    serializer.startTag(PublishedScopeResource.NS, "HostedOn").text(item.hostedOn).endTag(PublishedScopeResource.NS, "HostedOn");
                }
                if (item.timestamp != null) {
                    serializer.startTag(PublishedScopeResource.NS, "JointTime").text(ProfileDate.toXMLDateAndTime(item.timestamp)).endTag(PublishedScopeResource.NS, "JointTime");
                }
                serializer.endTag(PublishedScopeResource.NS, RESOURCE_ELEMENT);
            }
            serializer.endTag(PublishedScopeResource.NS, RESOURCES_ELEMENT);
        }

        void load(KXmlParser parser) throws Exception {
            block20: {
                try {
                    while (true) {
                        block1 : switch (parser.next()) {
                            case 2: {
                                if (parser.getName().equals(RESOURCE_ELEMENT)) {
                                    String id = null;
                                    String type = null;
                                    String hostedOn = null;
                                    Date time = null;
                                    while (true) {
                                        switch (parser.next()) {
                                            case 2: {
                                                if (parser.getName().equals("ResourceID")) {
                                                    id = parser.nextText();
                                                    break;
                                                }
                                                if (parser.getName().equals("ResourceType")) {
                                                    type = parser.nextText();
                                                    break;
                                                }
                                                if (parser.getName().equals("HostedOn")) {
                                                    hostedOn = parser.nextText();
                                                    break;
                                                }
                                                if (parser.getName().equals("JointTime")) {
                                                    time = ProfileDate.fromXMLDateAndTime(parser.nextText());
                                                    break;
                                                }
                                                parser.nextText();
                                                break;
                                            }
                                            case 3: {
                                                if (!parser.getName().equals(RESOURCE_ELEMENT)) break;
                                                this.add(id, type, time, hostedOn);
                                                break block1;
                                            }
                                            case 1: {
                                                throw new Exception("Parsing failed at ScopedRescource");
                                            }
                                        }
                                    }
                                }
                                break;
                            }
                            case 3: {
                                if (parser.getName().equals(RESOURCES_ELEMENT)) {
                                    break block20;
                                }
                                break;
                            }
                            case 1: {
                                throw new Exception("Failed to parse at ScopedRescources");
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new Exception("Failed to parse at Resources");
                }
            }
        }

        class Item {
            protected String id;
            protected String type;
            protected String hostedOn;
            protected Date timestamp;

            protected Item(String id, String value, Date timestamp, String ... hostedOn) {
                this.id = id;
                this.type = value;
                this.timestamp = timestamp;
                this.hostedOn = hostedOn != null && hostedOn.length > 0 ? hostedOn[0] : null;
            }

            protected Item(String id, String value, String ... hostedOn) {
                this(id, value, (Date)null, hostedOn);
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
                result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Item other = (Item)obj;
                if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                    return false;
                }
                return !(this.type == null ? other.type != null : !this.type.equals(other.type));
            }
        }
    }

    public static class UnknownScopeOptionException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

