package org.gcube.searchsystem.searchsystemservice;

import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;

import java.util.ArrayList;
import java.util.Calendar;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.searchsystem.cache.PlanCache;
import org.gcube.searchsystem.cache.PlanCacheManager;
import org.gcube.searchsystem.environmentadaptor.ResourceRegistryAdapter;
import org.gcube.searchsystem.planning.Orchestrator;
import org.gcube.searchsystem.searchsystemservice.stubs.SearchResponse;
import org.gcube.searchsystem.searchsystemservice.stubs.StringArray;
import org.gcube.searchsystem.workflow.PE2ngWorkflowAdaptor;

/**
 * Web Service front end to the gCube Search System
 * 
 * @author Vasilis Verroios
 */
public class SearchSystemService extends GCUBEPortType {
	/**
	 * The Logger used by this class
	 */
	private static GCUBELog logger = new GCUBELog(SearchSystemService.class);
	
	/**
	 * Creates a new {@link SearchSystemService}
	 */
	public SearchSystemService(){
	}

	/**
	 * Entry point to the search operation
	 * 
	 * @param query - The gCQL query to be answered 
	 * @return The ResultSet end point reference (containing the results) and a list of warnings
	 * @throws GCUBEFault An unrecoverable for the operation error occurred
	 */
	public SearchResponse search(String query) throws GCUBEFault {
		try{
			logger.info("received query: " + query);
			
			//for statistics
			long start=Calendar.getInstance().getTimeInMillis();
			
			Orchestrator orchestrator = new Orchestrator();
			
			//get cache for this scope
			PlanCache pCache = PlanCacheManager.getCacheWithName(ServiceContext.getContext().getScope().toString());
			
			EnvHintCollection adaptorHints = ServiceContext.getContext().getHints();
			adaptorHints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(ServiceContext.getContext().getScope().toString())));
			//get the rsEpr
			String rsEpr = orchestrator.search(query, 
					new ResourceRegistryAdapter(adaptorHints),
					new PE2ngWorkflowAdaptor(adaptorHints),
					pCache);

			//get the warnings list
			ArrayList<String> warnings = orchestrator.getWarnings();
			
			long end=Calendar.getInstance().getTimeInMillis();
			
			logger.info("finished after (millisecs): " + (end-start));
			
			SearchResponse response = new SearchResponse(rsEpr, 
					new StringArray(warnings.toArray(new String[warnings.size()])));
			
			return response;
			
		}catch(Exception e){
			logger.error("Error while executing query:", e);
			throw new GCUBEFault(e, e.getMessage());
		}
	}
	
	@Override
	protected GCUBEServiceContext getServiceContext() {
		return ServiceContext.getContext();
	}
}
