/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.search.adapter.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gcube.search.sru.search.adapter.service.helpers.RecordConverter;

public class SruSearchAdapterExplain {
    String version;
    String recordSchema;
    String recordPacking;
    String serverHost;
    Integer serverPort;
    String databaseName;
    String databaseTitle;
    String databaseDescription;
    String schemaID;
    String schemaName;
    Map<String, List<String>> indexInfo;
    Map<String, String> indexSets;
    int numberOfRecords;
    String retrieveSchema;

    public String getExplainXML() {
        String indexInfoXML = "";
        for (Map.Entry set : this.indexSets.entrySet()) {
            indexInfoXML = indexInfoXML + "\t\t\t\t\t<set identifier=\"" + (String)set.getKey() + "\" name=\"" + (String)set.getValue() + "\" />\n";
        }
        int id = 1;
        for (Map.Entry index : this.indexInfo.entrySet()) {
            String indexSet = (String)index.getKey();
            for (String map : (List)index.getValue()) {
                indexInfoXML = indexInfoXML + "\t\t\t\t\t<index id=\"" + id + "\">\n" + "\t\t\t\t\t\t<title>" + map + "</title>\n" + "\t\t\t\t\t\t<map>\n" + "\t\t\t\t\t\t\t<name set=\"" + indexSet + "\">" + map + "</name>\n" + "\t\t\t\t\t\t</map>\n" + "\t\t\t\t\t</index>\n";
                ++id;
            }
        }
        String xml = "<?xml version=\"1.0\"?><zs:explainResponse xmlns:zs=\"http://www.loc.gov/zing/srw/\">\n\t<zs:version>" + this.version + "</zs:version>\n" + "\t<zs:record>\n" + "\t\t<zs:recordSchema>" + this.recordSchema + "</zs:recordSchema>\n" + "\t\t<zs:recordPacking>" + this.recordPacking + "</zs:recordPacking>\n" + "\t\t<zs:recordData>\n" + "\t\t\t<explain xmlns=\"http://explain.z3950.org/dtd/2.0/\">\n" + "\t\t\t\t<serverInfo>\n" + "\t\t\t\t\t<host>" + this.serverHost + "</host>\n" + "\t\t\t\t\t<port>" + this.serverPort + "</port>\n" + "\t\t\t\t\t<database>" + this.databaseName + "</database>\n" + "\t\t\t\t</serverInfo>\n" + "\t\t\t\t<databaseInfo>\n" + "\t\t\t\t\t<title>" + this.databaseTitle + "</title>\n" + "\t\t\t\t\t<description lang=\"en\" primary=\"true\">\n" + "\t\t\t\t\t\t" + this.databaseDescription + "\n" + "\t\t\t\t\t</description>\n" + "\t\t\t\t</databaseInfo>\n" + "\t\t\t\t<indexInfo>\n" + indexInfoXML + "\t\t\t\t</indexInfo>\n" + "\n" + "\t\t\t\t<schemaInfo>\n" + "\t\t\t\t\t<schema identifier=\"" + this.schemaID + "\" sort=\"false\" name=\"" + this.schemaName + "\">\n" + "\t\t\t\t\t  <title>" + this.schemaName + "</title>\n" + "\t\t\t\t\t</schema>\n" + "\t\t\t\t</schemaInfo>\n" + "               <configInfo>\n" + "                   <default type=\"numberOfRecords\">" + this.numberOfRecords + "</default>\n" + "                  <default type=\"retrieveSchema\">" + this.retrieveSchema + "</default>" + "                  </configInfo>" + "\t\t\t</explain>\n" + "\t\t</zs:recordData>\n" + "\t</zs:record>\n" + "</zs:explainResponse>";
        return xml;
    }

    public static SruSearchAdapterExplain createExplain(Map<String, String> collections, Map<String, List<String>> fields, String hostname, Integer port, Boolean includeNonDC, int defaultNumberOfRecords) {
        HashMap indexSets = Maps.newHashMap();
        indexSets.put("info:srw/cql-context-set/1/cql-v1.1", "cql");
        indexSets.put("info:srw/cql-context-set/1/dc-v1.1", "oai_dc");
        HashMap collectionsAndFields = Maps.newHashMap();
        HashSet allFields = Sets.newHashSet();
        for (Map.Entry<String, List<String>> entry : fields.entrySet()) {
            allFields.addAll((Collection)entry.getValue());
        }
        if (!includeNonDC.booleanValue()) {
            allFields.retainAll(RecordConverter.DC_FIELDS);
        }
        collectionsAndFields.put("oai_dc", Lists.newArrayList((Iterable)allFields));
        collectionsAndFields.put("cql", Lists.newArrayList((Object[])new String[]{"allIndexes"}));
        SruSearchAdapterExplain explain = new SruSearchAdapterExplain();
        explain.indexSets = indexSets;
        explain.indexInfo = collectionsAndFields;
        explain.schemaID = "info:srw/schema/1/dc-v1.1";
        explain.recordSchema = "http://explain.z3950.org/dtd/2.0/";
        explain.databaseTitle = "gCube Search";
        explain.serverHost = hostname;
        explain.serverPort = port;
        explain.version = "1.1";
        explain.schemaName = "oai_dc";
        explain.recordPacking = "xml";
        explain.numberOfRecords = defaultNumberOfRecords;
        explain.retrieveSchema = "info:srw/schema/1/dc-v1.1";
        return explain;
    }

    public static void main(String[] args) {
        SruSearchAdapterExplain explain = new SruSearchAdapterExplain();
        explain.version = "1.1";
        explain.recordSchema = "http://explain.z3950.org/dtd/2.0/";
        explain.recordPacking = "xml";
        explain.serverHost = "jazzman.di.uoa.gr";
        explain.serverPort = 3306;
        explain.databaseName = "test";
        explain.databaseTitle = "Test";
        explain.databaseDescription = "Test mysql database";
        explain.indexSets = new HashMap();
        explain.indexSets.put("cql", "info:srw/cql-context-set/1/cql-v1.1");
        explain.indexSets.put("books", "info:srw/cql-context-set/1/db-v1.1");
        explain.indexInfo = new HashMap();
        explain.indexInfo.put("books", Lists.newArrayList((Object[])new String[]{"author", "title"}));
        explain.schemaID = "http://www.loc.gov/mods";
        explain.schemaName = "rss";
        System.out.println(explain.getExplainXML());
    }
}

