/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch;

import gr.forth.ics.isl.stellaclustering.CLT_Creator;
import gr.forth.ics.isl.textentitymining.gate.GateAnnie;
import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Initialize
extends HttpServlet {
    public int num = 0;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        if (this.num == 0) {
            System.out.println("------");
            CLT_Creator.InitializeClusteringProperties((String)Resources.CLUSTERING_PROPERTIES_FILE);
            System.out.println("------");
            GateAnnie.InitializeMiningProperties((String)Resources.MINING_PROPERTIES_FILE);
            this.InitializeXSearchProperties(Resources.X_SEARCH_PROPERTIES_FILE);
            System.out.println("------");
            System.out.println("Executing Annie Gate...");
            try {
                GateAnnie.InitializeGate();
            }
            catch (Exception ex) {
                System.out.println("*** Error Initializing GateAnnie: " + ex.getMessage());
            }
            System.out.println("# The system is ready to accept requests!");
        }
        ++this.num;
        String address = "index.jsp";
        RequestDispatcher dispatcher = request.getRequestDispatcher(address);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void InitializeXSearchProperties(String propertiesFilePath) {
        System.out.println("# Initializing X-Search Properties...");
        try {
            String getPropertiesQuery;
            String conf;
            String tmp;
            String log;
            String miningResults;
            String[] acceptedCategoriesArray;
            String[] allCategoriesArray;
            String descriptionDocument;
            Properties prop = new Properties();
            FileInputStream in = new FileInputStream(propertiesFilePath);
            prop.load(in);
            Resources.DESCRIPTIONDOCUMENT = descriptionDocument = prop.getProperty("gr.forth.ics.isl.xsearch.resources.opensearch.descriptionDocument");
            String clusteringAlgorithmString = prop.getProperty("gr.forth.ics.isl.xsearch.resources.clustering.clusteringAlgorithm");
            try {
                int clusteringAlgorithm = Integer.parseInt(clusteringAlgorithmString.trim());
                if (clusteringAlgorithm < 1 || clusteringAlgorithm > 5) {
                    System.out.println("*** NOT APPROPRIATE CLUSTERING ALGORITHM! VALUE NOT AN INTEGER IN THE INTERVAL [1, 5]. SETTING DEFAULT ALGORITHM 3 (NM-STC).");
                    clusteringAlgorithm = 3;
                }
                Resources.CLUSTERING_ALGORITHM = clusteringAlgorithm;
            }
            catch (Exception e) {
                System.out.println("*** NOT APPROPRIATE CLUSTERING ALGORITHM! VALUE NOT AN INTEGER IN THE INTERVAL [1, 5]. SETTING DEFAULT ALGORITHM 3 (NM-STC).");
                Resources.CLUSTERING_ALGORITHM = 3;
            }
            String mineQueryString = prop.getProperty("gr.forth.ics.isl.xsearch.resources.mining.mineQuery");
            Resources.MINE_QUERY = mineQueryString.toLowerCase().equals("true");
            Resources.MINING_ALL_POSSIBLE_CATEGORIES = new HashSet();
            String allCategories = prop.getProperty("gr.forth.ics.isl.xsearch.resources.mining.allPossibleCategories");
            for (String oneCategory : allCategoriesArray = allCategories.split(",")) {
                if (oneCategory.trim().equals("")) continue;
                Resources.MINING_ALL_POSSIBLE_CATEGORIES.add(oneCategory.trim());
            }
            Resources.MINING_ACCEPTED_CATEGORIES = new HashSet();
            String acceptedCategories = prop.getProperty("gr.forth.ics.isl.xsearch.resources.mining.acceptedCategories");
            for (String acceptedCategory : acceptedCategoriesArray = acceptedCategories.split(",")) {
                if (acceptedCategory.trim().equals("")) continue;
                Resources.MINING_ACCEPTED_CATEGORIES.add(acceptedCategory.trim());
            }
            Resources.SPARQL_ENDPOINTS = new HashMap();
            Resources.SPARQL_TEMPLATES = new HashMap();
            for (String acceptedCategory : Resources.MINING_ACCEPTED_CATEGORIES) {
                String sparqlTemplate;
                String sparqlEndpoint = prop.getProperty("gr.forth.ics.isl.xsearch.resources.entityenrichment.sparqlendpoint." + acceptedCategory);
                if (sparqlEndpoint != null) {
                    Resources.SPARQL_ENDPOINTS.put(acceptedCategory, sparqlEndpoint.trim());
                }
                if ((sparqlTemplate = prop.getProperty("gr.forth.ics.isl.xsearch.resources.entityenrichment.templatequery." + acceptedCategory)) == null) continue;
                Resources.SPARQL_TEMPLATES.put(acceptedCategory, sparqlTemplate.trim());
            }
            Resources.MINING_RESULTS = miningResults = prop.getProperty("gr.forth.ics.isl.xsearch.resources.mining.miningResultsFolder");
            Resources.LOG = log = prop.getProperty("gr.forth.ics.isl.xsearch.resources.log");
            Resources.TEMP_FOLDER = tmp = prop.getProperty("gr.forth.ics.isl.xsearch.resources.tempFolder");
            Resources.CONFIGURATIONS_FOLDER = conf = prop.getProperty("gr.forth.ics.isl.xsearch.resources.configurationsFolder");
            Resources.GET_PROPERTIES_TEMPLATE_QUERY = getPropertiesQuery = prop.getProperty("gr.forth.ics.isl.xsearch.resources.entityenrichment.templatequery.getpropertiesquery");
            System.out.println("=> OPENSEARCH DESCRIPTION DOCUMENT: " + Resources.DESCRIPTIONDOCUMENT);
            System.out.println("=> CLUSTERING ALGORITHM: " + Resources.CLUSTERING_ALGORITHM);
            System.out.println("=> MINE QUERY: " + Resources.MINE_QUERY);
            System.out.println("=> MINING ALL POSSIBLE CATEGORIES: " + Resources.MINING_ALL_POSSIBLE_CATEGORIES);
            System.out.println("=> MINING ACCEPTED CATEGORIES: " + Resources.MINING_ACCEPTED_CATEGORIES);
            System.out.println("=> SPARQL ENDPOINTS: " + Resources.SPARQL_ENDPOINTS);
            System.out.println("=> SPARQL TEMPLATES: " + Resources.SPARQL_TEMPLATES);
            System.out.println("=> MINING RESULTS FOLDER: " + Resources.MINING_RESULTS);
            System.out.println("=> LOG FOLDER: " + Resources.LOG);
            System.out.println("=> TEMP FOLDER: " + Resources.TEMP_FOLDER);
            System.out.println("=> CONFIGURATIONS FOLDER: " + Resources.CONFIGURATIONS_FOLDER);
            System.out.println("=> GET PROPERTIES TEMPLATE QUERY: " + Resources.GET_PROPERTIES_TEMPLATE_QUERY);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            System.out.println("*** PROBLEM READING X-SEARCH PROPERTIES FILE: " + e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

