/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch;

import gr.forth.ics.isl.xsearch.Bean_Search;
import gr.forth.ics.isl.xsearch.IOSLog;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SemanticSearch
extends HttpServlet {
    private String query;
    private int n;
    private boolean mining;
    private boolean clustering;
    private boolean only_snippets;
    private int numOfClusters;
    private String locator;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, GRS2ReaderException, URISyntaxException, GRS2RecordDefinitionException, GRS2BufferException {
        response.setContentType("text/plain;charset=UTF-8");
        long start = System.currentTimeMillis();
        this.query = request.getParameter("query");
        if (this.query == null) {
            this.query = "";
        }
        String num = request.getParameter("n");
        try {
            this.n = Integer.parseInt(num);
        }
        catch (Exception e) {
            this.n = 1000;
        }
        String type = request.getParameter("type");
        if (type == null) {
            type = "";
        }
        this.only_snippets = !type.equals("fullContent");
        String mining_checkbox = request.getParameter("mining");
        if (mining_checkbox == null) {
            mining_checkbox = "false";
        }
        this.mining = mining_checkbox.toLowerCase().equals("true");
        String clustering_checkbox = request.getParameter("clustering");
        if (clustering_checkbox == null) {
            clustering_checkbox = "false";
        }
        this.clustering = clustering_checkbox.toLowerCase().equals("true");
        String clnum = request.getParameter("clnum");
        this.numOfClusters = clnum == null ? (this.clustering ? 15 : 0) : Integer.parseInt(clnum);
        this.locator = request.getParameter("locator");
        if (this.locator == null) {
            System.out.println("*** NULL LOCATOR!");
            this.locator = "";
        }
        this.locator = URLDecoder.decode(this.locator, "utf8");
        Bean_Search results = new Bean_Search(this.query, this.n, this.clustering, this.numOfClusters, this.mining, this.only_snippets, this.locator);
        int numOfResults = results.getWseResults().size();
        String jsonResults = results.getJsonResults();
        PrintWriter out = response.getWriter();
        out.print(jsonResults);
        long end = System.currentTimeMillis() - start;
        System.out.println("# TOTAL TIME: " + end + " ms.");
        System.out.println("--------");
        this.updateLog(request, this.n, this.mining, this.clustering, this.only_snippets, this.numOfClusters, numOfResults, end);
    }

    private void updateLog(HttpServletRequest request, int num, boolean mining, boolean clustering, boolean only_snippets, int clnum, int numOfResults, long time) {
        String ip = request.getRemoteAddr();
        String date = IOSLog.getCurrentDate();
        String line = "\nx-search\t" + date + "\t" + ip + "\t(GCUBE REQUEST)\tSUBMITTED_BY_GCUBE NUM=" + num + " MINING=" + mining + " CLUSTERING=" + clustering + " ONLY_SNIPPETS=" + only_snippets + " CLNUM=" + clnum + " NUM_OF_RETURNED_RESULTS=" + numOfResults + " RETRIEVAL_TIME=" + time + "ms";
        IOSLog.writeToLog((String)line);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (GRS2ReaderException ex) {
            Logger.getLogger(SemanticSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(SemanticSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (GRS2RecordDefinitionException ex) {
            Logger.getLogger(SemanticSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (GRS2BufferException ex) {
            Logger.getLogger(SemanticSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (GRS2ReaderException ex) {
            Logger.getLogger(SemanticSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(SemanticSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (GRS2RecordDefinitionException ex) {
            Logger.getLogger(SemanticSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (GRS2BufferException ex) {
            Logger.getLogger(SemanticSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "Short description";
    }
}

