/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.admin;

import gr.forth.ics.isl.xsearch.admin.ChangeTemplate;
import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AddEntityEnrichment
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        HttpSession session = request.getSession();
        String loggedin = (String)session.getAttribute("loggedin");
        if (loggedin == null) {
            loggedin = "no";
            session.setAttribute("loggedin", (Object)loggedin);
            RequestDispatcher dispatcher = request.getRequestDispatcher("login.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        PrintWriter out = response.getWriter();
        out.print("");
        try {
            String endpoint;
            String category = request.getParameter("category");
            if (category == null) {
                category = "";
            }
            if ((endpoint = request.getParameter("endpoint")) == null) {
                endpoint = "";
            }
            endpoint = URLDecoder.decode(endpoint, "utf-8");
            String template = request.getParameter("template");
            if (template == null) {
                template = "";
            }
            template = URLDecoder.decode(template, "utf-8");
            if (endpoint.trim().equals("")) {
                out.print("Attention! Empty SPARQL endpoint!");
                out.close();
                return;
            }
            URL url = new URL(endpoint);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            int endpointResponseCode = connection.getResponseCode();
            String sampleQ = "select ?x where { ?x ?y ?z } limit 1";
            sampleQ = URLEncoder.encode(sampleQ, "utf8");
            String sampleQpath = endpoint + sampleQ;
            System.out.println("# Sample query path: " + sampleQpath);
            url = new URL(sampleQpath);
            connection = (HttpURLConnection)url.openConnection();
            int sampleQResponseCode = connection.getResponseCode();
            String sampleQResponseMess = connection.getResponseMessage();
            if (endpointResponseCode != 400 || sampleQResponseCode != 200) {
                if (endpointResponseCode != 400) {
                    out.print("Not a SPARQL endpoint! Please check it!");
                    out.close();
                    return;
                }
                out.print("Could not run the sample query! Message: " + sampleQResponseMess + ". <br />(The path of the endpoint must be ready to accept a query, e.g. it must end with 'query=')");
                out.close();
                return;
            }
            if (template.trim().equals("")) {
                out.print("Attention! Empty SPARQL template query!");
                out.close();
                return;
            }
            if (!(template.toLowerCase().contains("select") && template.toLowerCase().contains("where") && template.toLowerCase().contains("?") && template.toLowerCase().contains("{") && template.toLowerCase().contains("}"))) {
                out.print("Attention! The SPARQL template query is not valid!");
                out.close();
                return;
            }
            if (!template.contains("<ENTITY>")) {
                out.print("Attention! The SPARQL template query does not contain the parameter '&lt;ENTITY&gt;'!");
                out.close();
                return;
            }
            String filename = category.toLowerCase().replaceAll("[^a-zA-Z]+", "_");
            String templateFilename = Resources.TEMP_FOLDER;
            if (!Resources.TEMP_FOLDER.endsWith("/") && !Resources.TEMP_FOLDER.endsWith("\\")) {
                templateFilename = templateFilename + "/";
            }
            templateFilename = templateFilename + filename;
            templateFilename = templateFilename + ".template";
            ChangeTemplate.writeTemplateQuery((String)category, (String)template, (String)templateFilename);
            Resources.SPARQL_TEMPLATES.put(category, templateFilename);
            Resources.SPARQL_ENDPOINTS.put(category, endpoint);
        }
        catch (Exception e) {
            out.print(e.getMessage().replace("\n", " "));
        }
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

