/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.admin;

import gr.forth.ics.isl.xsearch.opensearch.DescriptionDocument;
import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ChangeDescriptionDocument
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        HttpSession session = request.getSession();
        String loggedin = (String)session.getAttribute("loggedin");
        if (loggedin == null) {
            loggedin = "no";
            session.setAttribute("loggedin", (Object)loggedin);
            RequestDispatcher dispatcher = request.getRequestDispatcher("login.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        PrintWriter out = response.getWriter();
        out.print("");
        String doc = request.getParameter("doc");
        if (doc == null) {
            doc = "";
        }
        if ((doc = URLDecoder.decode(doc, "utf-8")).toLowerCase().startsWith("figis")) {
            Resources.DESCRIPTIONDOCUMENT = doc;
            System.out.println("# New description document: " + Resources.DESCRIPTIONDOCUMENT);
            out.close();
            return;
        }
        DescriptionDocument descrDoc = null;
        try {
            descrDoc = new DescriptionDocument(doc);
        }
        catch (Exception e) {
            System.out.println("*** ERROR READING DESCRIPTION DOCUMENT!");
            out.print("Error reading description document!");
            return;
        }
        if (descrDoc.isErrorReadingDocument()) {
            out.print("Error reading description document!");
        } else if (descrDoc.getUrlTemplates().isEmpty()) {
            System.out.println("=> Attention! No URL templates in this document! The description document was not changed!");
            out.print("No URL templates!");
        } else if (!descrDoc.getUrlTemplates().containsKey("application/rss+xml") && !descrDoc.getUrlTemplates().containsKey("application/atom+xml")) {
            out.print("No supported template types! For the present we support only 'application/rss+xml' and 'application/atom+xml' results.");
        } else {
            Resources.DESCRIPTIONDOCUMENT = doc;
            System.out.println("# New description document: " + Resources.DESCRIPTIONDOCUMENT);
            System.out.println("# URL templates: " + descrDoc.getUrlTemplates());
        }
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

