/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.admin;

import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoadConfiguration
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        HttpSession session = request.getSession();
        String loggedin = (String)session.getAttribute("loggedin");
        if (loggedin == null) {
            loggedin = "no";
            session.setAttribute("loggedin", (Object)loggedin);
            RequestDispatcher dispatcher = request.getRequestDispatcher("login.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        PrintWriter out = response.getWriter();
        out.print("");
        InputStream in = null;
        try {
            String[] acceptedCategoriesArray;
            String id = request.getParameter("id");
            if (id == null) {
                id = "";
            }
            String propertiesFile = Resources.CONFIGURATIONS_FOLDER;
            if (!Resources.CONFIGURATIONS_FOLDER.endsWith("/") && !Resources.CONFIGURATIONS_FOLDER.endsWith("\\")) {
                propertiesFile = propertiesFile + "/";
            }
            propertiesFile = propertiesFile + "conf" + id + ".properties";
            Properties prop = new Properties();
            in = new FileInputStream(propertiesFile);
            prop.load(in);
            String descriptionDocument = prop.getProperty("gr.forth.ics.isl.xsearch.resources.opensearch.descriptionDocument");
            if (descriptionDocument != null) {
                Resources.DESCRIPTIONDOCUMENT = descriptionDocument.trim();
            }
            String clusteringAlgorithmString = prop.getProperty("gr.forth.ics.isl.xsearch.resources.clustering.clusteringAlgorithm");
            try {
                int clusteringAlgorithm = Integer.parseInt(clusteringAlgorithmString.trim());
                if (clusteringAlgorithm < 1 || clusteringAlgorithm > 5) {
                    System.out.println("*** NOT APPROPRIATE CLUSTERING ALGORITHM! THE CLUSTERING ALGORITH WAS NOT LOADED!");
                } else {
                    Resources.CLUSTERING_ALGORITHM = clusteringAlgorithm;
                }
            }
            catch (Exception e) {
                System.out.println("*** ERROR READING CLUSTERING ALGORITHM! THE CLUSTERING ALGORITH WAS NOT LOADED! ");
            }
            String mineQueryString = prop.getProperty("gr.forth.ics.isl.xsearch.resources.mining.mineQuery");
            try {
                Resources.MINE_QUERY = mineQueryString.trim().toLowerCase().equals("true");
            }
            catch (Exception e) {
                System.out.println("*** ERROR READING PROPERTY 'MINE QUERY'! THIS PROPERTY WAS NOT LOADED! ");
            }
            Resources.MINING_ACCEPTED_CATEGORIES = new HashSet();
            String acceptedCategories = prop.getProperty("gr.forth.ics.isl.xsearch.resources.mining.acceptedCategories");
            for (String acceptedCategory : acceptedCategoriesArray = acceptedCategories.split(",")) {
                if (acceptedCategory.trim().equals("")) continue;
                Resources.MINING_ACCEPTED_CATEGORIES.add(acceptedCategory.trim());
            }
            Resources.SPARQL_ENDPOINTS = new HashMap();
            Resources.SPARQL_TEMPLATES = new HashMap();
            for (String acceptedCategory : Resources.MINING_ACCEPTED_CATEGORIES) {
                String sparqlTemplate;
                String sparqlEndpoint = prop.getProperty("gr.forth.ics.isl.xsearch.resources.entityenrichment.sparqlendpoint." + acceptedCategory);
                if (sparqlEndpoint != null) {
                    Resources.SPARQL_ENDPOINTS.put(acceptedCategory, sparqlEndpoint.trim());
                }
                if ((sparqlTemplate = prop.getProperty("gr.forth.ics.isl.xsearch.resources.entityenrichment.templatequery." + acceptedCategory)) == null) continue;
                Resources.SPARQL_TEMPLATES.put(acceptedCategory, sparqlTemplate.trim());
            }
            System.out.println("# The configuration file with ID = " + id + " was successfully loaded!");
        }
        catch (Exception e) {
            out.print(e.getMessage().replace("\n", " "));
        }
        in.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

