/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.clustering;

import gr.forth.ics.isl.stellaclustering.CLT_Creator;
import gr.forth.ics.isl.stellaclustering.ContentToCluster;
import gr.forth.ics.isl.stellaclustering.util.TreeNode;
import gr.forth.ics.isl.xsearch.SearchResult;
import gr.forth.ics.isl.xsearch.resources.Resources;
import java.util.ArrayList;
import java.util.Enumeration;

public class Clustering {
    private String clustersContent;
    private String query;
    private int numOfClusters;
    private boolean onlySnippets;
    private ArrayList<SearchResult> wseResults;
    private CLT_Creator clusterer;

    public Clustering(ArrayList<SearchResult> wseResults, String query, boolean onlySnippets, int numOfClusters) {
        this.query = query;
        this.numOfClusters = numOfClusters;
        this.onlySnippets = onlySnippets;
        this.wseResults = wseResults;
        ArrayList<ContentToCluster> contentsToCluster = new ArrayList<ContentToCluster>();
        for (SearchResult wse_res : wseResults) {
            ContentToCluster content = onlySnippets ? new ContentToCluster(wse_res.getTitle(), wse_res.getDescription()) : new ContentToCluster(wse_res.getTitle() + " | " + wse_res.getDescription(), wse_res.getContent());
            contentsToCluster.add(content);
        }
        this.clusterer = new CLT_Creator(query, contentsToCluster, Resources.CLUSTERING_ALGORITHM, numOfClusters);
        TreeNode clt = this.clusterer.getClusterTree();
        this.formClustersString(clt, contentsToCluster);
    }

    private void formClustersString(TreeNode clt, ArrayList<ContentToCluster> contents) {
        this.clustersContent = "";
        String storedQuery = this.query;
        if (contents != null && !contents.isEmpty()) {
            storedQuery = storedQuery.replace("'", "&quot;").replace("\"", "&quot;");
            this.clustersContent = this.clustersContent + "<script>eval(\"Node = CreateProjectExplorer('" + storedQuery + "(" + contents.size() + ")');\");</script>";
            StringBuilder tmpVec = new StringBuilder();
            Enumeration en = clt.children();
            while (en.hasMoreElements()) {
                TreeNode leftChild = (TreeNode)en.nextElement();
                String Title = leftChild.getTitle();
                ArrayList v = (ArrayList)leftChild.getUserObject();
                int size = v.size();
                Enumeration en1 = leftChild.children();
                tmpVec.setLength(0);
                String docs = "";
                for (int j = 0; j < v.size(); ++j) {
                    int rank = (Integer)v.get(j);
                    docs = docs + --rank;
                    if (j == v.size() - 1) continue;
                    docs = docs + ",";
                }
                this.clustersContent = this.clustersContent + "<script>eval(\"aNode=createProjectNode(Node,'" + Title + "(" + size + ")'," + !leftChild.isLeaf() + ",'" + docs + "');\");</script>";
                tmpVec.setLength(0);
                while (en1.hasMoreElements()) {
                    leftChild = (TreeNode)en1.nextElement();
                    Title = leftChild.getTitle();
                    v = (ArrayList)leftChild.getUserObject();
                    size = v.size();
                    Enumeration en2 = leftChild.children();
                    tmpVec.setLength(0);
                    docs = "";
                    for (int j = 0; j < v.size(); ++j) {
                        int rank = (Integer)v.get(j);
                        docs = docs + --rank;
                        if (j == v.size() - 1) continue;
                        docs = docs + ",";
                    }
                    this.clustersContent = this.clustersContent + "<script>eval(\"bNode = createProjectNode(aNode,'" + Title + "(" + size + ")'," + !leftChild.isLeaf() + ",'" + docs + "');\");</script>";
                    tmpVec.setLength(0);
                    while (en2.hasMoreElements()) {
                        leftChild = (TreeNode)en2.nextElement();
                        Title = leftChild.getTitle();
                        v = (ArrayList)leftChild.getUserObject();
                        size = v.size();
                        Enumeration en3 = leftChild.children();
                        tmpVec.setLength(0);
                        docs = "";
                        for (int j = 0; j < v.size(); ++j) {
                            int rank = (Integer)v.get(j);
                            docs = docs + --rank;
                            if (j == v.size() - 1) continue;
                            docs = docs + ",";
                        }
                        this.clustersContent = this.clustersContent + "<script>eval(\"cNode = createProjectNode(bNode,'" + Title + "(" + size + ")'," + !leftChild.isLeaf() + ",'" + docs + "');\");</script>";
                        tmpVec.setLength(0);
                        while (en3.hasMoreElements()) {
                            int rank;
                            int j;
                            leftChild = (TreeNode)en3.nextElement();
                            Title = leftChild.getTitle();
                            v = (ArrayList)leftChild.getUserObject();
                            Enumeration en4 = leftChild.children();
                            size = v.size();
                            docs = "";
                            for (j = 0; j < v.size(); ++j) {
                                rank = (Integer)v.get(j);
                                docs = docs + --rank;
                                if (j == v.size() - 1) continue;
                                docs = docs + ",";
                            }
                            this.clustersContent = this.clustersContent + "<script>eval(\"dNode = createProjectNode(cNode,'" + Title + "(" + size + ")'," + !leftChild.isLeaf() + ",'" + docs + "');\");</script>";
                            tmpVec.setLength(0);
                            while (en4.hasMoreElements()) {
                                leftChild = (TreeNode)en4.nextElement();
                                Title = leftChild.getTitle();
                                v = (ArrayList)leftChild.getUserObject();
                                size = v.size();
                                docs = "";
                                for (j = 0; j < v.size(); ++j) {
                                    rank = (Integer)v.get(j);
                                    docs = docs + --rank;
                                    if (j == v.size() - 1) continue;
                                    docs = docs + ",";
                                }
                                this.clustersContent = this.clustersContent + "<script>eval(\"createProjectNode(dNode,'" + Title + "(" + size + ")'," + !leftChild.isLeaf() + ",'" + docs + "');\");</script>";
                            }
                        }
                    }
                }
            }
        }
    }

    public String getClustersContent() {
        return this.clustersContent;
    }

    public void setClustersContent(String clustersContent) {
        this.clustersContent = clustersContent;
    }

    public int getNumOfClusters() {
        return this.numOfClusters;
    }

    public void setNumOfClusters(int numOfClusters) {
        this.numOfClusters = numOfClusters;
    }

    public boolean isOnlySnippets() {
        return this.onlySnippets;
    }

    public void setOnlySnippets(boolean onlySnippets) {
        this.onlySnippets = onlySnippets;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public ArrayList<SearchResult> getWseResults() {
        return this.wseResults;
    }

    public void setWseResults(ArrayList<SearchResult> wseResults) {
        this.wseResults = wseResults;
    }

    public CLT_Creator getClusterer() {
        return this.clusterer;
    }

    public void setClusterer(CLT_Creator clusterer) {
        this.clusterer = clusterer;
    }
}

