
<%@page import="gr.forth.ics.isl.xsearch.resources.Resources"%>
<%@page import="gr.forth.ics.isl.xsearch.IOSLog"%>
<%@page import="java.net.URLEncoder"%>
<%@ page contentType="text/html;charset=utf-8" %>


<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <link rel="icon" href="files/graphics/favicon.ico" type="image/x-icon" />
        <title>IOS | Instant Overview Search - About</title>


        <link rel="stylesheet" type="text/css" href="css/about.css" />

    </head>
    <body>

        <%

            String ip = request.getRemoteAddr();
            String date = IOSLog.getCurrentDate();

            String line = "\n" + Resources.SYSTEMNAME + "\t" + date + "\t" + ip + "\tOPENING THE ABOUT PAGE!";
            IOSLog.writeToLog(line);
        %>

        <div class="headerContainer">
            <div class="header">

                <div class="logo">
                    <a title="Instant Overview Search - Home Page" href="./">
                        <img src="files/graphics/ios_logo_notype.png" />
                    </a>
                </div>
                <div class="menu">
                    <div class="nav">
                        <ul class="menuitems">
                            <li class="menuitem">
                                <a href="#whatis">What is IOS?</a>
                            </li>
                            <li class="menuitem">
                                <a href="#prototypes">Running prototypes</a>
                            </li>
                            <li class="menuitem">
                                <a href="#publications">Publications</a>
                            </li>
                            <li class="menuitem">
                                <a href="#contact">Contact</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="contentContainer">


            <div class="content">


                <div class="infocontent" id="whatis">
                    <font class="info_title">
                        &raquo;&nbsp;What is <span class="ios">IOS</span>?
                    </font>
                    <hr width="100%" size="0.01em" align="left" style="color:#ccc" noshade="noshade" />
                    <font class="info_text">
                        <span class="iosfull">Instant Overview Search</span>, 
                        for short <span class="ios">IOS</span>, 
                        is a "search-as-you-type" functionality for web searching 
                        which provides an overview of the results as the user types his query letter-by-letter.
                        Specifically, for the most frequent queries it shows instantly the top hits 
                        and various other kinds of <u>precomputed aggregated information</u> 
                        that provide the user with a better overview of the search space.
                        This method is independent of the kind of precomputed information, 
                        hence it can be adopted for a plethora of applications 
                        (e.g. results clustering, metadata-based groupings, entity mining,
                        query recommendations, semantic-based enhancements, etc).
                        <!--
                        Obviously, the overall effectiveness of <span class="ios">ios</span>, apart from its efficiency,
                        depends on the quality of the precomputed information. 
                        However, the proposed functionality can be used with any autocompletion, ranking, clustering, entity mining, etc. algorithm.
                        -->
                        <br />&nbsp;<br />
                        At present, we investigate how to exploit the Semantic Web technologies for 
                        enriching the entities that have been identified in the web search results. 
                        Specifically, we study how the Linked Open Data cloud can be exploited for 
                        providing further information about the entities that lie in the search results 
                        of both general purpose web search engines (<a href="#demo5">running prototype 5</a>) and 
                        vertical search scenarios (<a href="#demo6">running prototype 6</a>).
                        We have developed a fully configurable semantic web search service, 
                        the so-called <a href="#demo5">X-Search</a>, 
                        that reads the description of an underlying search source, 
                        and is able to query that source and analyze in various ways the returned results.
                    </font>
                </div>

                <div class="gotop">
                    <span class="gotoptext"><a href="javascript:scroll(0,0);">top</a></span>
                </div>

                <div class="infocontent" id="prototypes">
                    <font class="info_title">
                        &raquo;&nbsp;Running prototypes
                    </font>
                    <hr width="100%" size="0.01em" align="left" style="color:#ccc" noshade="noshade" />
                    <font class="info_text">

                        <span id="demo1">
                            1) A meta-search engine offering instant clustering of the snippets of the top hits.
                            The current deployment contains precomputed information for 20,000 queries.
                            In case user does not get any suggestion for the current input, he is able to submit the query and get the "fresh" results and their cluster label tree.
                            The prototype also supports faceted search-like restriction of the answer, 
                            i.e. the user is able to gradually select clusters and refine the answer set accordingly.
                            For the clustering of the top results, we adopt the algorithm <a target="_blank" href="Servlet_OpenURI?uri=http://www.ics.forth.gr/~tzitzik/publications/Tzitzikas_2009_WISE.pdf" title="STC+ and HSTC: Two Novel Online Results Clustering Methods for Web Searching">NM-STC</a>.
                            <ul><a href="Servlet_OpenURI?uri=http://139.91.183.72/ios_stie/?sys=sys_mse" target="_blank" title="IOS and clustering of the top hits"><font size="+1">Click here and try the demo!</font></a></ul>
                        </span>

                        <br />

                        <span id="demo2">
                            2) A standalone web search engine offering instant meta-data based grouping of the top hits. 
                            In particular, user can limit the search space according to various dynamic taxonomies (e.g. filetype, date, domain, etc.).
                            The current demo contains precomputed information for about 100 queries.
                            In case user does not get any suggestion for the current input, he is able to submit the query. 
                            In that case, he is redirected at <a target="_blank" href="Servlet_OpenURI?uri=http://groogle.csd.uoc.gr:8080/mitos/" titl="Mitos Web Search Engine">mitos</a> web search engine.
                            You can find more information about dynamic taxonomies <a target="_blank" title="Dynamic Taxonomies and Faceted Search: Theory, Practice and Experience" href="Servlet_OpenURI?uri=http://www.ics.forth.gr/~tzitzik/fbook/index.html">here</a>. 
                            <ul><a href="Servlet_OpenURI?uri=http://139.91.183.72/ios_mitos/?sys=sys_wse" target="_blank" title="IOS and metadata-based groupings"><font size="+1">Click here and try the demo!</font></a></ul>
                        </span>

                        <br />

                        <span id="demo3">
                            3) A meta-search engine offering instant entity mining of the contents of the top hits.
                            The current deployment contains precomputed information for about 2,000 queries.
                            In case user does not get any suggestion for the current input, he is able to submit the query and get the results and a categorized list with the discovered entities (of either the snippets or the full contents of the results).
                            You can find more information about web searching with entity mining at query time <a target="_blank" title="Web Searching with Entity Mining at Query Time" href="http://www.ics.forth.gr/~tzitzik/publications/Tzitzikas_2012_IRF.pdf">here</a>. 
                            <ul><a href="Servlet_OpenURI?uri=http://139.91.183.72/ios_em/?sys=sys_em" target="_blank" title="IOS and Entity Mining"><font size="+1">Click here and try the demo!</font></a></ul>
                        </span>

                        <br />

                        <span id="demo4">
                            4) A meta-search engine offering both instant clustering of the snippets and instant entity mining of the contents of the top hits. 
                            The current deployment contains precomputed information for about 2,000 queries.
                            In case user does not get any suggestion for the current input, he is able to submit the query and get the cluster label tree and a categorized list with the discovered entities (of either the snippets or the full contents of the results).
                            <ul><a href="Servlet_OpenURI?uri=http://139.91.183.72/ios_em_cl/?sys=sys_em_cl" target="_blank" title="IOS and Clustering+Entity Mining"><font size="+1">Click here and try the demo!</font></a></ul>
                        </span>

                        <br />

                        <%
                            String path = "http://139.91.183.72/x-search/Servlet_Search?query=barack+obama&start=0&n=50&type=onlySnippets&mining=true&clustering=true&clnum=15";
                            String encodedPath = URLEncoder.encode(path, "utf8");
                        %>

                        <span id="demo5">
                            5) A meta-search engine offering "semantically enriched" entity mining of the top hits. 
                            Specifically, user is able to retrieve more information about a discovered entity 
                            by simply clicking the icon <img src="files/graphics/lod.jpg" /> next to entity's label. 
                            In that case and according to the category of the selected entity, 
                            a SPARQL query is sent trying to fetch more information about that entity from the Linked Open Data cloud, 
                            exploiting various LOD datasets that offer access through SPARQL endpoints (like <a href="Servlet_OpenURI?uri=http://www.dbpedia.org/" target="_blank">DBpedia</a> and <a href="Servlet_OpenURI?uri=http://www.factforge.net/" target="_blank">FactForge</a>).
                            <ul><a href="Servlet_OpenURI?uri=<%=encodedPath%>" target="_blank" title="IOS and Semantically Enriched Entity Mining"><font size="+1">Click here and try the demo!</font></a></ul>
                        </span>

                        <br />

                        <%
                            path = "http://139.91.183.72/x-search-fao/Servlet_Search?query=fish&start=0&n=50&type=onlySnippets&mining=true&clustering=true&clnum=15";
                            encodedPath = URLEncoder.encode(path, "utf8");
                        %>

                        <span id="demo6">
                            6) Case Study: <i>"Fisheries and Aquaculture publications"</i>. 
                            Apart from the case of general purpose web searching, we have started investigating the 
                            "semantically enriched" entity mining approach in vertical search scenarios.
                            One of this is the domain of FAO (<a target="_blank" href="Servlet_OpenURI?uri=http://www.fao.org/">Food and Agriculture Organization</a>) publications about
                            fisheries and aquaculture. The underlying keyword search system is the 
                            <a target="_blank" href="Servlet_OpenURI?uri=http://www.fao.org/fishery/search/en">FIGIS</a> search component.
                            As concern entity mining, we identify the following additional relevant categories:
                            <i>Countries</i>, <i>Water Areas</i>, <i>Regional Fisheries Bodies</i>, and <i>Marine Species</i>.
                            Furthermore, user is able to retrieve more information about a discovered entity from the Fisheries Linked Open Data (FLOD) RDF dataset
                            (FLOD is exposed via a public <a target="_blank" href="Servlet_OpenURI?uri=http://www.fao.org/figis/flod/endpoint/sparql">SPARQL endpoint</a>).
                            <ul><a href="Servlet_OpenURI?uri=<%=encodedPath%>" target="_blank" title="IOS and Semantically Enriched Entity Mining over FIGIS"><font size="+1">Click here and try the demo!</font></a></ul>
                        </span>
                    </font>
                </div>

                <div class="gotop">
                    <span class="gotoptext"><a href="javascript:scroll(0,0);">top</a></span>
                </div>

                <div class="infocontent" id="publications">
                    <font class="info_title">
                        &raquo;&nbsp;Publications
                    </font>
                    <hr width="100%" size="0.01em" align="left" style="color:#ccc" noshade="noshade" />
                    <font class="info_text">

                        1) P. Fafalios and Y. Tzitzikas
                        <br />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<i>"Exploiting Available Memory and Disk for Scalable Instant Overview Search"</i>
                        <br />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;12th International Conference on Web Information System Engineering, WISE 2011, Sydney, Australia, October 2011 
                        <br />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(<a target="_blank" href="Servlet_OpenURI?uri=http://www.ics.forth.gr/~tzitzik/publications/Tzitzikas_2011_WISE.pdf" title="Exploiting Available Memory and Disk for Scalable Instant Overview Search">pdf</a>&nbsp;&bull;&nbsp;<a href="Servlet_OpenURI?uri=http://www.ics.forth.gr/~fafalios/fafalios2011exploiting.bib" title="Exploiting Available Memory and Disk for Scalable Instant Overview Search - BIB Entry" target="_blank">bib</a>)
                        <br />&nbsp;<br />

                        2) P. Fafalios, I. Kitsos and Y. Tzitzikas
                        <br />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<i>"Scalable, Flexible and Generic Instant Overview Search"</i>
                        <br />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Demo Paper, Proceedings of the 21st International Conference on World Wide Web, WWW 2012, Lyon, France, April 2012. 
                        <br />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(<a href="Servlet_OpenURI?uri=http://www.ics.forth.gr/~tzitzik/publications/Tzitzikas_2012_WWW.pdf" title="Scalable, Flexible and Generic Instant Overview Search" target="_blank">pdf</a>&nbsp;&bull;&nbsp;<a href="Servlet_OpenURI?uri=http://www.ics.forth.gr/~fafalios/ios-presentation.pdf" target="_blank" title="Scalable, Flexible and Generic Instant Overview Search - Presentation">ppt</a>&nbsp;&bull;&nbsp;<a href="Servlet_OpenURI?uri=http://www.ics.forth.gr/~fafalios/fafalios2012scalable.bib" title="Scalable, Flexible and Generic Instant Overview Search - BIB Entry" target="_blank">bib</a>)
                        <br />&nbsp;<br />

                        3) P. Fafalios, I. Kitsos, Y. Marketakis, C. Baldassarre, M. Salampasis and Y. Tzitzikas
                        <br />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<i>"Web Searching with Entity Mining at Query Time"</i>
                        <br />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Proceedings of the 5th Information Retrieval Facility Conference, IRF 2012, Vienna, July 2012. 
                        <br />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(<a href="Servlet_OpenURI?uri=http://www.ics.forth.gr/~tzitzik/publications/Tzitzikas_2012_IRF.pdf" target="_blank" title="Web Searching with Entity Mining at Query Time">pdf</a>&nbsp;&bull;&nbsp;<a href="Servlet_OpenURI?uri=http://www.ics.forth.gr/~fafalios/fafalios2012websearching.bib" title="Web Searching with Entity Mining at Query Time - BIB Entry" target="_blank">bib</a>)

                    </font>
                </div>

                <div class="gotop">
                    <span class="gotoptext"><a href="javascript:scroll(0,0);">top</a></span>
                </div>

                <div class="infocontent" id="contact">
                    <font class="info_title">
                        &raquo;&nbsp;Contact
                    </font>
                    <hr width="100%" size="0.01em" align="left" style="color:#ccc" noshade="noshade" />
                    <font class="info_text">

                        This system was developed in the scope of
                        <a href="mailto:fafalios@csd.uoc.gr">Pavlos Fafalios</a> master's thesis 
                        under the supervision of <a href="mailto:tzitzik@ics.forth.gr">Yannis Tzitzikas</a>,
                        assistant professor at the University of Crete, 
                        and was partially supported by the EU project <a href="Servlet_OpenURI?uri=http://www.i-marine.eu/" title="iMarine EU Project" target="_blank">iMarine</a> (FP7-283644).

                        <br />&nbsp;<br />
                        <div class="contact">
                            <font size="+1">Pavlos Fafalios</font>
                            <br />
                            <a href="Servlet_OpenURI?uri=http://www.csd.uoc.gr/" target="_blank" title="Computer Science Department, University of Crete">Computer Science Department, University of Crete, Greece</a>
                            <br />
                            <a href="Servlet_OpenURI?uri=http://www.ics.forth.gr/isl/" target="_blank" title="">Information Systems Laboratory, Institute of  Computer Science, Foundation for Research and Technology - Hellas (FORTH), Greece</a>
                            <br />
                            Email: <a href="mailto:fafalios@csd.uoc.gr">fafalios@csd.uoc.gr</a>
                            <br />
                            Web page: <a target="_blank" href="Servlet_OpenURI?uri=http://www.ics.forth.gr/~fafalios/">http://www.ics.forth.gr/~fafalios/</a>
                        </div>

                        <br />

                        <div class="contact">
                            <font size="+1">Yannis Tzitzikas</font>
                            <br />
                            <a href="Servlet_OpenURI?uri=http://www.csd.uoc.gr/" target="_blank" title="Computer Science Department, University of Crete">Computer Science Department, University of Crete, Greece</a>
                            <br />
                            <a href="Servlet_OpenURI?uri=http://www.ics.forth.gr/isl/" target="_blank" title="">Information Systems Laboratory, Institute of  Computer Science, Foundation for Research and Technology - Hellas (FORTH), Greece</a>
                            <br />
                            Email: <a href="mailto:tzitzik@ics.forth.gr">tzitzik@ics.forth.gr</a>
                            <br />
                            Web page: <a target="_blank" href="Servlet_OpenURI?uri=http://www.ics.forth.gr/~tzitzik/">http://www.ics.forth.gr/~tzitzik/</a>
                        </div>

                    </font>
                </div>

                <div class="gotop">
                    <span class="gotoptext"><a href="javascript:scroll(0,0);">top</a></span>
                </div>

            </div>
        </div>

        <div class="footer">
            &nbsp;
        </div>




    </body>
</html>
