/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.admin;

import gr.forth.ics.isl.textentitymining.gate.GateAnnie;
import gr.forth.ics.isl.textentitymining.gate.addcategory.AddCategory;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.TreeSet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UpdateCategoryNamedEntities
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        HttpSession session = request.getSession();
        String loggedin = (String)session.getAttribute("loggedin");
        if (loggedin == null) {
            loggedin = "no";
            session.setAttribute("loggedin", (Object)loggedin);
            RequestDispatcher dispatcher = request.getRequestDispatcher("login.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        PrintWriter out = response.getWriter();
        out.print("");
        try {
            String[] words;
            String categoryName = request.getParameter("categoryName");
            if (categoryName == null) {
                categoryName = "";
            }
            if (categoryName.trim().equals("")) {
                out.print("Attention! You must give a category name!");
                out.close();
                return;
            }
            String list = request.getParameter("list");
            if (list == null) {
                list = "";
            }
            list = URLDecoder.decode(list, "utf-8");
            TreeSet<String> wordsSet = new TreeSet<String>();
            for (String word : words = list.split("\n")) {
                if ((word = word.trim().toLowerCase()).equals("")) continue;
                wordsSet.add(word);
            }
            if (wordsSet.isEmpty()) {
                out.print("Attention! You must give a set of words or phrases!");
                out.close();
                return;
            }
            System.out.println("# Category: " + categoryName);
            System.out.println("# Number of words/phrases: " + wordsSet.size());
            AddCategory add = new AddCategory();
            add.setCategoryName(categoryName);
            add.setCategoryNameNoSpace(categoryName.replace(" ", "_"));
            add.initializeVariables();
            String categoryFile = add.getLIST_FILE_NAME();
            System.out.println("# Category file: ");
            PrintWriter writer = new PrintWriter(categoryFile, "UTF-8");
            for (String word : wordsSet) {
                writer.println(word);
            }
            writer.close();
            GateAnnie.RestartGate();
        }
        catch (Exception e) {
            out.print("Attention!" + e.getMessage().replace("\n", " "));
        }
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

