/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.inspecting;

import gr.forth.ics.isl.xsearch.IOSLog;
import gr.forth.ics.isl.xsearch.inspecting.SparqlRunner;
import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ShowProperties
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            int ii2;
            LinkedHashMap resultsMap;
            String uri = request.getParameter("uri");
            if (uri == null) {
                System.out.println("*** EMPTY URI!");
                out.print("<h3><center>Sorry!<br />No properties for this URI!</center></h3>");
                out.close();
                return;
            }
            uri = URLDecoder.decode(uri, "utf8");
            uri = uri.replace("[NUMBERSIGN]", "#");
            String category = request.getParameter("category");
            if (category == null) {
                System.out.println("*** EMPTY CATEGORY!");
                out.print("<h3><center>Sorry!<br />No properties for this URI!</center></h3>");
                out.close();
                return;
            }
            String bubbleid = "bubble" + request.getParameter("rand");
            System.out.println("# Retrieving properties of " + uri);
            HttpSession session = request.getSession();
            String query = (String)session.getAttribute("submitted_query");
            this.updateLog(request, query, uri);
            HashMap endpoints = (HashMap)session.getAttribute("endpoints");
            if (endpoints == null) {
                endpoints = Resources.SPARQL_ENDPOINTS;
            }
            if ((resultsMap = SparqlRunner.getProperties((String)category, (String)uri, (HashMap)endpoints)).isEmpty()) {
                out.print("<a target='_blank' href='" + uri + "'>" + uri + "</a>");
                out.close();
                return;
            }
            int ii = uri.lastIndexOf("/");
            String displayURI = uri;
            if (ii != -1 && (ii2 = (displayURI = uri.substring(ii + 1)).lastIndexOf("#")) != -1) {
                displayURI = displayURI.substring(ii2 + 1);
            }
            displayURI = displayURI.substring(0, 1).toUpperCase() + displayURI.substring(1);
            out.print("<font style=\"font-size: 13px; font-weight:bold\">Properties of: <a title=\"" + uri + "\" href=\"" + uri + "\" target=\"_blank\">" + displayURI + "</a></font>");
            out.print("<br />&nbsp;<br />");
            for (String property : resultsMap.keySet()) {
                HashSet propertyValues = (HashSet)resultsMap.get(property);
                out.print("<table class='infoboxPropertyTable'>");
                out.print("<tr>");
                out.print("<td align='center' class='infoboxPropertyTitle'>");
                if (property.toLowerCase().startsWith("http://")) {
                    int i2;
                    String displayProp = property;
                    int i1 = property.lastIndexOf("/");
                    if (i1 != -1 && (i2 = (displayProp = property.substring(i1 + 1)).lastIndexOf("#")) != -1) {
                        displayProp = displayProp.substring(i2 + 1);
                    }
                    if ((displayProp = displayProp.substring(0, 1).toUpperCase() + displayProp.substring(1)).length() > 100) {
                        displayProp = displayProp.substring(0, 99) + "...";
                    }
                    String passproperty = property.replace("#", "[NUMBERSIGN]");
                    String href = "javascript:showProperties(\"" + category + "\", \"" + URLEncoder.encode(passproperty, "utf8") + "\",\"" + bubbleid + "\");";
                    out.print("<a title='" + property + "' href='" + href + "'>" + displayProp + "</a>");
                } else {
                    out.print(property);
                }
                out.print("</td>");
                out.print("<tr>");
                out.print("<td class='infoboxPropertyValues'>");
                for (String value : propertyValues) {
                    if (value.toLowerCase().startsWith("http://")) {
                        int i2;
                        String displayValue = value;
                        int i1 = displayValue.lastIndexOf("/");
                        if (i1 != -1 && (i2 = (displayValue = displayValue.substring(i1 + 1)).lastIndexOf("#")) != -1) {
                            displayValue = displayValue.substring(i2 + 1);
                        }
                        displayValue = displayValue.substring(0, 1).toUpperCase() + displayValue.substring(1);
                        String passvalue = value.replace("#", "[NUMBERSIGN]");
                        String href = "javascript:showProperties(\"" + category + "\", \"" + URLEncoder.encode(passvalue, "utf8") + "\",\"" + bubbleid + "\");";
                        out.print("&bull;&nbsp;<a title='" + value + "' href='" + href + "'>" + displayValue + "</a>");
                        out.print("&nbsp;&nbsp;<a href='" + value + "' target='_blank' class='em_minepage'>(open)</a>");
                    } else {
                        out.print("&bull;&nbsp;" + value);
                    }
                    out.print("<br />");
                }
                out.print("</td>");
                out.print("</tr>");
                out.print("</table>");
            }
        }
        finally {
            out.close();
        }
    }

    public void updateLog(HttpServletRequest request, String query, String uri) {
        String ip = request.getRemoteAddr();
        String date = IOSLog.getCurrentDate();
        String line = "\nx-search\t" + date + "\t" + ip + "\t" + query + "\tRETRIEVING PROPERTIES OF '" + uri;
        IOSLog.writeToLog((String)line);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

