/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.api;

import gr.forth.ics.isl.stellaclustering.CLT_Creator;
import gr.forth.ics.isl.stellaclustering.util.TreeNode;
import gr.forth.ics.isl.textentitymining.Category;
import gr.forth.ics.isl.textentitymining.Entity;
import gr.forth.ics.isl.xsearch.Bean_Search;
import gr.forth.ics.isl.xsearch.IOSLog;
import gr.forth.ics.isl.xsearch.SearchResult;
import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class processresults
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Element categ_el;
        Bean_Search bean;
        String format;
        String typeofresults;
        String numofclusters;
        String categories;
        String searchsystem = request.getParameter("searchsystem");
        if (searchsystem == null) {
            searchsystem = "";
        }
        if ((searchsystem = searchsystem.trim()).equals("")) {
            response.sendError(400, "The value of the parameter 'searchsystem' is null or empty.");
            return;
        }
        if (!Resources.SUPPORTED_SEARCH_SYSTEMS.keySet().contains(searchsystem.toLowerCase())) {
            response.sendError(400, "The value of the parameter 'searchsystem' is not valid. Accepted values: " + Resources.SUPPORTED_SEARCH_SYSTEMS.keySet() + ".");
            return;
        }
        String locator = request.getParameter("locator");
        if (locator == null) {
            locator = "";
        }
        locator = locator.trim();
        locator = URLDecoder.decode(locator, "utf8");
        if (searchsystem.toLowerCase().equals("gcube") && locator.equals("")) {
            response.sendError(400, "The value of the parameter 'locator' (gCube locator) is NULL or empty. Provide a value or change the search system.");
            return;
        }
        String descrdoc = request.getParameter("descrdoc");
        if (descrdoc == null) {
            descrdoc = "";
        }
        descrdoc = descrdoc.trim();
        descrdoc = URLDecoder.decode(descrdoc, "utf8");
        if (searchsystem.toLowerCase().equals("opensearch") && descrdoc.equals("")) {
            response.sendError(400, "The value of the parameter 'descrdoc' (URL of OpenSearch Description Document) is NULL or empty. Provide a value or change the search system.");
            return;
        }
        String query = request.getParameter("query");
        if (query == null) {
            query = "";
        }
        if ((query = query.trim()).equals("") && !searchsystem.toLowerCase().equals("gcube")) {
            response.sendError(400, "The value of the parameter 'query' is null or empty.");
            return;
        }
        String numofresults = request.getParameter("numofresults");
        if (numofresults == null) {
            numofresults = "";
        }
        numofresults = numofresults.trim();
        int num = 100;
        if (!numofresults.equals("")) {
            try {
                num = Integer.parseInt(numofresults);
            }
            catch (Exception e) {
                response.sendError(400, "Error in reading the value of the parameter 'numofresults'. Please check the value.");
                return;
            }
        }
        if (num <= 0) {
            response.sendError(400, "The value of the parameter 'numofresults' cannot be a negative number. Please check the value.");
            return;
        }
        String mining = request.getParameter("mining");
        if (mining == null) {
            mining = "";
        }
        mining = mining.trim();
        boolean allowMining = true;
        if (!mining.equals("")) {
            if (!mining.toLowerCase().equals("true") && !mining.toLowerCase().equals("false")) {
                response.sendError(400, "The value of the parameter 'mining' is not valid. Valid values: {true, false}.");
                return;
            }
            try {
                allowMining = Boolean.parseBoolean(mining);
            }
            catch (Exception e) {
                response.sendError(400, "Error in reading the value of the parameter 'mining'. Please check the value.");
                return;
            }
        }
        if ((categories = request.getParameter("categories")) == null) {
            categories = "";
        }
        categories = categories.trim();
        HashSet<String> acceptedCategories = new HashSet<String>();
        if (categories.equals("")) {
            for (String c : Resources.MINING_ACCEPTED_CATEGORIES) {
                acceptedCategories.add(c);
            }
        } else {
            String[] categs;
            for (String c : categs = categories.split(";")) {
                acceptedCategories.add(c.trim());
            }
        }
        if (!Resources.MINING_ALL_POSSIBLE_CATEGORIES.containsAll(acceptedCategories)) {
            response.sendError(400, "One or more of the provided categories are not currently supported by the entity mining component.");
            return;
        }
        String clustering = request.getParameter("clustering");
        if (clustering == null) {
            clustering = "";
        }
        clustering = clustering.trim();
        boolean allowClustering = true;
        if (!clustering.equals("")) {
            if (!clustering.toLowerCase().equals("true") && !clustering.toLowerCase().equals("false")) {
                response.sendError(400, "The value of the parameter 'clustering' is not valid. Valid values: {true, false}.");
                return;
            }
            try {
                allowClustering = Boolean.parseBoolean(clustering);
            }
            catch (Exception e) {
                response.sendError(400, "Error in reading the value of the parameter 'clustering'. Please check the value.");
                return;
            }
        }
        if ((numofclusters = request.getParameter("numofclusters")) == null) {
            numofclusters = "";
        }
        numofclusters = numofclusters.trim();
        int clusters = 15;
        if (!numofclusters.equals("")) {
            try {
                clusters = Integer.parseInt(numofclusters);
            }
            catch (Exception e) {
                response.sendError(400, "Error in reading the value of the parameter 'numofclusters'. Please check the value.");
                return;
            }
        }
        if (clusters <= 0) {
            response.sendError(400, "The value of the parameter 'numofclusters' cannot be a negative number. Please check the value.");
            return;
        }
        String clusteringalg = request.getParameter("clusteringalg");
        if (clusteringalg == null) {
            clusteringalg = "";
        }
        if (!(clusteringalg = clusteringalg.trim()).equals("")) {
            if (!Resources.SUPPORTED_CLUSTERING_ALGORITHMS.keySet().contains(clusteringalg)) {
                response.sendError(400, "The value of the parameter 'clusteringalg' is not valid. Valid values: " + Resources.SUPPORTED_CLUSTERING_ALGORITHMS.keySet() + ".");
                return;
            }
        } else {
            clusteringalg = "cl3";
        }
        if ((typeofresults = request.getParameter("typeofresults")) == null) {
            typeofresults = "";
        }
        if (!(typeofresults = typeofresults.trim()).equals("")) {
            if (!typeofresults.equals("snippets") && !typeofresults.equals("contents")) {
                response.sendError(400, "The value of the parameter 'typeofresults' is not valid. Valid values: {snippets, contents}.");
                return;
            }
        } else {
            typeofresults = "snippets";
        }
        if ((format = request.getParameter("format")) == null) {
            format = "";
        }
        if (!(format = format.trim()).equals("")) {
            if (!format.toLowerCase().equals("json") && !format.toLowerCase().equals("xml")) {
                response.sendError(400, "The value of the parameter 'format' is not valid. Valid values: {json, xml}.");
                return;
            }
        } else {
            format = "json";
        }
        System.out.println("# Input:");
        System.out.println("searchsystem = " + searchsystem);
        System.out.println("descrdoc = " + descrdoc);
        System.out.println("locator = " + locator);
        System.out.println("query = " + query);
        System.out.println("numofresults = " + num);
        System.out.println("mining = " + allowMining);
        System.out.println("categories = " + acceptedCategories);
        System.out.println("clustering = " + allowClustering);
        System.out.println("numofclusters = " + clusters);
        System.out.println("clusteringalg = " + clusteringalg);
        System.out.println("typeofresults = " + typeofresults);
        System.out.println("format = " + format);
        try {
            bean = new Bean_Search(searchsystem, query, descrdoc, locator, num, allowMining, acceptedCategories, allowClustering, clusters, clusteringalg, typeofresults);
        }
        catch (Exception e) {
            response.sendError(400, "Error: " + e.getMessage() + " - Please check the given parameters and try again.");
            return;
        }
        if (format.toLowerCase().equals("json")) {
            JSONArray json_rs = this.createResultsJSONArray(bean.getWseResults());
            JSONObject j = new JSONObject();
            j.put((Object)"topResults", (Object)json_rs);
            if (allowMining) {
                JSONArray json_em = this.createEntityMiningJSONArray(bean.getEntities());
                j.put((Object)"resultOfEntityMining", (Object)json_em);
            }
            if (allowClustering) {
                JSONArray json_cl = this.createClusteringJSONArray(bean.getClusteringComponent().getClusterer());
                j.put((Object)"resultOfClustering", (Object)json_cl);
            }
            JSONObject inputParams = new JSONObject();
            inputParams.put((Object)"searchsystem", (Object)searchsystem);
            inputParams.put((Object)"query", (Object)query);
            inputParams.put((Object)"descrdoc", (Object)descrdoc);
            inputParams.put((Object)"locator", (Object)locator);
            inputParams.put((Object)"numofresults", (Object)num);
            inputParams.put((Object)"mining", (Object)allowMining);
            JSONArray categs = new JSONArray();
            for (String categ : acceptedCategories) {
                categs.add((Object)categ);
            }
            inputParams.put((Object)"categories", (Object)categs);
            inputParams.put((Object)"clustering", (Object)allowClustering);
            inputParams.put((Object)"numofclusters", (Object)clusters);
            inputParams.put((Object)"clusteringalg", (Object)clusteringalg);
            inputParams.put((Object)"typeofresults", (Object)typeofresults);
            inputParams.put((Object)"format", (Object)format);
            j.put((Object)"inputParameters", (Object)inputParams);
            j.put((Object)"date", (Object)IOSLog.getCurrentDate());
            JSONObject json = new JSONObject();
            json.put((Object)"result", (Object)j);
            response.setContentType("application/json;charset=UTF-8");
            PrintWriter out = response.getWriter();
            try {
                out.print(json);
            }
            finally {
                out.close();
            }
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("result");
        doc.appendChild(rootElement);
        Element inputParameters = doc.createElement("inputParameters");
        Element resultOfEntityMining = doc.createElement("resultOfEntityMining");
        Element resultOfClustering = doc.createElement("resultOfClustering");
        Element topResults = doc.createElement("topResults");
        Element date = doc.createElement("date");
        rootElement.appendChild(inputParameters);
        rootElement.appendChild(resultOfEntityMining);
        rootElement.appendChild(resultOfClustering);
        rootElement.appendChild(topResults);
        rootElement.appendChild(date);
        Element searchsystem_el = doc.createElement("searchsystem");
        Element query_el = doc.createElement("query");
        Element descrdoc_el = doc.createElement("descrdoc");
        Element locator_el = doc.createElement("locator");
        Element numofresults_el = doc.createElement("numofresults");
        Element mining_el = doc.createElement("mining");
        Element categories_el = doc.createElement("categories");
        Element clustering_el = doc.createElement("clustering");
        Element numofclusters_el = doc.createElement("numofclusters");
        Element clusteringalg_el = doc.createElement("clusteringalg");
        Element typeofresults_el = doc.createElement("typeofresults");
        Element format_el = doc.createElement("format");
        searchsystem_el.appendChild(doc.createTextNode(searchsystem));
        inputParameters.appendChild(searchsystem_el);
        query_el.appendChild(doc.createTextNode(query));
        inputParameters.appendChild(query_el);
        descrdoc_el.appendChild(doc.createTextNode(descrdoc));
        inputParameters.appendChild(descrdoc_el);
        locator_el.appendChild(doc.createTextNode(locator));
        inputParameters.appendChild(locator_el);
        numofresults_el.appendChild(doc.createTextNode("" + num));
        inputParameters.appendChild(numofresults_el);
        mining_el.appendChild(doc.createTextNode("" + allowMining));
        inputParameters.appendChild(mining_el);
        for (String categ : acceptedCategories) {
            categ_el = doc.createElement("categoryName");
            categ_el.appendChild(doc.createTextNode(categ));
            categories_el.appendChild(categ_el);
        }
        inputParameters.appendChild(categories_el);
        clustering_el.appendChild(doc.createTextNode("" + allowClustering));
        inputParameters.appendChild(clustering_el);
        numofclusters_el.appendChild(doc.createTextNode("" + clusters));
        inputParameters.appendChild(numofclusters_el);
        clusteringalg_el.appendChild(doc.createTextNode(clusteringalg));
        inputParameters.appendChild(clusteringalg_el);
        typeofresults_el.appendChild(doc.createTextNode(typeofresults));
        inputParameters.appendChild(typeofresults_el);
        format_el.appendChild(doc.createTextNode(format));
        inputParameters.appendChild(format_el);
        Element categs_el = doc.createElement("categories");
        for (int i = 0; i < bean.getEntities().size(); ++i) {
            categ_el = doc.createElement("category");
            categs_el.appendChild(categ_el);
            Element categName_el = doc.createElement("categoryName");
            categName_el.appendChild(doc.createTextNode(((Category)bean.getEntities().get(i)).getName()));
            categ_el.appendChild(categName_el);
            Element categrank_el = doc.createElement("rank");
            categrank_el.appendChild(doc.createTextNode("" + (i + 1)));
            categ_el.appendChild(categrank_el);
            Element entities_el = doc.createElement("entities");
            categ_el.appendChild(entities_el);
            for (int j = 0; j < ((Category)bean.getEntities().get(i)).getEntities().size(); ++j) {
                Element entity_el = doc.createElement("entity");
                Element entityName_el = doc.createElement("entityName");
                String entityName = ((Entity)((Category)bean.getEntities().get(i)).getEntities().get(j)).getName();
                entityName_el.appendChild(doc.createTextNode(entityName));
                entity_el.appendChild(entityName_el);
                Element documents_els = doc.createElement("documentsIDs");
                for (int k = 0; k < ((Entity)((Category)bean.getEntities().get(i)).getEntities().get(j)).getDocIds().size(); ++k) {
                    Element id_el = doc.createElement("id");
                    id_el.appendChild(doc.createTextNode("" + ((Entity)((Category)bean.getEntities().get(i)).getEntities().get(j)).getDocIds().get(k)));
                    documents_els.appendChild(id_el);
                }
                entity_el.appendChild(documents_els);
                Element score_el = doc.createElement("score");
                double score = ((Entity)((Category)bean.getEntities().get(i)).getEntities().get(j)).getRank();
                score_el.appendChild(doc.createTextNode("" + score));
                entity_el.appendChild(score_el);
                entities_el.appendChild(entity_el);
            }
        }
        resultOfEntityMining.appendChild(categs_el);
        Element clusters_el = doc.createElement("clusters");
        int numCl = 1;
        Enumeration enumer = bean.getClusteringComponent().getClusterer().getClusterTree().preorderEnumeration();
        while (enumer.hasMoreElements()) {
            TreeNode node = (TreeNode)enumer.nextElement();
            if (node.getLevel() > 1 || node.isRoot()) continue;
            Element cluster_el = doc.createElement("cluster");
            Element clusterLabel_el = doc.createElement("clusterLabel");
            clusterLabel_el.appendChild(doc.createTextNode(node.getTitle()));
            cluster_el.appendChild(clusterLabel_el);
            Element clusterRank_el = doc.createElement("rank");
            clusterRank_el.appendChild(doc.createTextNode("" + numCl++));
            cluster_el.appendChild(clusterRank_el);
            Element documents_els = doc.createElement("documentsIDs");
            for (int i = 0; i < node.getDocumentsList().size(); ++i) {
                Element id_el = doc.createElement("id");
                id_el.appendChild(doc.createTextNode("" + ((Integer)node.getDocumentsList().get(i) - 1)));
                documents_els.appendChild(id_el);
            }
            cluster_el.appendChild(documents_els);
            clusters_el.appendChild(cluster_el);
        }
        resultOfClustering.appendChild(clusters_el);
        for (int i = 0; i < bean.getWseResults().size(); ++i) {
            SearchResult result = (SearchResult)bean.getWseResults().get(i);
            Element result_el = doc.createElement("result");
            topResults.appendChild(result_el);
            Element title_el = doc.createElement("title");
            title_el.appendChild(doc.createTextNode(result.getTitle()));
            result_el.appendChild(title_el);
            Element description_el = doc.createElement("description");
            description_el.appendChild(doc.createTextNode(result.getDescription()));
            result_el.appendChild(description_el);
            Element url_el = doc.createElement("url");
            url_el.appendChild(doc.createTextNode(result.getUrl()));
            result_el.appendChild(url_el);
            Element rank_el = doc.createElement("rank");
            rank_el.appendChild(doc.createTextNode("" + result.getRank()));
            result_el.appendChild(rank_el);
            Element id_el = doc.createElement("id");
            id_el.appendChild(doc.createTextNode("" + i));
            result_el.appendChild(id_el);
        }
        date.appendChild(doc.createTextNode(IOSLog.getCurrentDate()));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        response.setContentType("application/xml;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        finally {
            out.close();
        }
        System.out.println("# PROCESS RESULTS - FINISHED!");
    }

    private JSONArray createEntityMiningJSONArray(ArrayList<Category> categories) {
        JSONArray jsonCategories = new JSONArray();
        for (int i = 0; i < categories.size(); ++i) {
            JSONArray jsonEntitiesArray = new JSONArray();
            JSONObject jsonCategory = new JSONObject();
            for (int j = 0; j < categories.get(i).getEntities().size(); ++j) {
                JSONObject jsonEntity = new JSONObject();
                jsonEntity.put((Object)"entityName", (Object)((Entity)categories.get(i).getEntities().get(j)).getName());
                JSONArray jsonDocArray = new JSONArray();
                for (int k = 0; k < ((Entity)categories.get(i).getEntities().get(j)).getDocIds().size(); ++k) {
                    jsonDocArray.add(((Entity)categories.get(i).getEntities().get(j)).getDocIds().get(k));
                }
                jsonEntity.put((Object)"documentsIDs", (Object)jsonDocArray);
                jsonEntity.put((Object)"score", (Object)((Entity)categories.get(i).getEntities().get(j)).getRank());
                jsonEntitiesArray.add((Object)jsonEntity);
            }
            jsonCategory.put((Object)"entities", (Object)jsonEntitiesArray);
            jsonCategory.put((Object)"categoryName", (Object)categories.get(i).getName());
            jsonCategory.put((Object)"rank", (Object)(i + 1));
            jsonCategories.add((Object)jsonCategory);
        }
        return jsonCategories;
    }

    private JSONArray createClusteringJSONArray(CLT_Creator clt) {
        JSONArray jsonClustersArray = new JSONArray();
        Enumeration enumer = clt.getClusterTree().preorderEnumeration();
        int num = 1;
        while (enumer.hasMoreElements()) {
            TreeNode node = (TreeNode)enumer.nextElement();
            if (node.getLevel() > 1 || node.isRoot()) continue;
            JSONObject jsonCluster = new JSONObject();
            jsonCluster.put((Object)"clusterLabel", (Object)node.getTitle());
            jsonCluster.put((Object)"rank", (Object)num++);
            JSONArray jsonDocArray = new JSONArray();
            for (int i = 0; i < node.getDocumentsList().size(); ++i) {
                jsonDocArray.add((Object)((Integer)node.getDocumentsList().get(i) - 1));
            }
            jsonCluster.put((Object)"documentsIDs", (Object)jsonDocArray);
            jsonClustersArray.add((Object)jsonCluster);
        }
        return jsonClustersArray;
    }

    private JSONArray createResultsJSONArray(ArrayList<SearchResult> wseResults) {
        JSONArray jsonResultsArray = new JSONArray();
        for (int i = 0; i < wseResults.size(); ++i) {
            SearchResult result = wseResults.get(i);
            JSONObject jsonResult = new JSONObject();
            jsonResult.put((Object)"title", (Object)result.getTitle());
            jsonResult.put((Object)"description", (Object)result.getDescription());
            jsonResult.put((Object)"url", (Object)result.getUrl());
            jsonResult.put((Object)"rank", (Object)result.getRank());
            jsonResult.put((Object)"id", (Object)i);
            jsonResultsArray.add((Object)jsonResult);
        }
        return jsonResultsArray;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, MalformedURLException, FileNotFoundException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(processresults.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(processresults.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "Short description";
    }
}

