/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.api;

import gr.forth.ics.isl.xsearch.api.processdocument;
import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class getsupportedsearchsystems
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ParserConfigurationException, TransformerConfigurationException {
        PrintWriter out = response.getWriter();
        String format = request.getParameter("format");
        if (format == null) {
            format = "";
        }
        if (!(format = format.trim()).equals("")) {
            if (!(format.toLowerCase().equals("json") || format.toLowerCase().equals("xml") || format.toLowerCase().equals("csv"))) {
                response.sendError(400, "The value of the parameter 'format' is not valid. Valid values: {json, xml, csv}.");
                return;
            }
        } else {
            format = "json";
        }
        try {
            if (format.toLowerCase().equals("csv")) {
                response.setContentType("text/plain;charset=UTF-8");
                out.println("\"SEARCH_SYSTEM_NAME\"\t\"SEARCH_SYSTEM_DESCRIPTION\"");
                for (String ss : Resources.SUPPORTED_SEARCH_SYSTEMS.keySet()) {
                    out.println(ss + "\t" + (String)Resources.SUPPORTED_SEARCH_SYSTEMS.get(ss));
                }
            } else if (format.toLowerCase().equals("xml")) {
                response.setContentType("application/xml;charset=UTF-8");
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("supportedSearchSystems");
                doc.appendChild(rootElement);
                for (String n : Resources.SUPPORTED_SEARCH_SYSTEMS.keySet()) {
                    Element searchsystem = doc.createElement("searchSystem");
                    Element name = doc.createElement("name");
                    name.appendChild(doc.createTextNode(n));
                    Element desc = doc.createElement("description");
                    desc.appendChild(doc.createTextNode((String)Resources.SUPPORTED_SEARCH_SYSTEMS.get(n)));
                    searchsystem.appendChild(name);
                    searchsystem.appendChild(desc);
                    rootElement.appendChild(searchsystem);
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(out);
                try {
                    transformer.transform(source, result);
                }
                catch (TransformerException ex) {
                    Logger.getLogger(processdocument.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                response.setContentType("application/json;charset=UTF-8");
                JSONObject json = new JSONObject();
                JSONArray searchsystem = new JSONArray();
                for (String ss : Resources.SUPPORTED_SEARCH_SYSTEMS.keySet()) {
                    JSONObject one = new JSONObject();
                    one.put((Object)"name", (Object)ss);
                    one.put((Object)"description", Resources.SUPPORTED_SEARCH_SYSTEMS.get(ss));
                    searchsystem.add((Object)one);
                }
                json.put((Object)"supportedSearchSystems", (Object)searchsystem);
                out.print(json);
                out.close();
            }
        }
        finally {
            out.close();
        }
        System.out.println("# GET SUPPORTED SEARCH SYSTEMS - FINISHED!");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(getsupportedsearchsystems.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(getsupportedsearchsystems.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(getsupportedsearchsystems.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(getsupportedsearchsystems.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "Short description";
    }
}

