/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch;

import gr.forth.ics.isl.stellaclustering.CLT_Creator;
import gr.forth.ics.isl.textentitymining.gate.GateAnnie;
import gr.forth.ics.isl.xsearch.FileDownloader;
import gr.forth.ics.isl.xsearch.IOSLog;
import gr.forth.ics.isl.xsearch.TCPServer;
import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class InitializatorListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        System.out.println("# Downloading resources...");
        Resources.MAIN_SERVLET_CONTEXT = sce.getServletContext();
        Resources.MAIN_RESOURCES_FOLDER = Resources.MAIN_SERVLET_CONTEXT.getRealPath("/resources/");
        Resources.MAIN_RESOURCES_FOLDER = Resources.MAIN_RESOURCES_FOLDER + "/";
        new FileDownloader().download("http://svn.research-infrastructures.eu/public/d4science/gcube/trunk/semantic-search/XSearch-Service-conf/XSearchResources.tar.gz", Resources.MAIN_RESOURCES_FOLDER + "XSearchResources.tar.gz").decompress(Resources.MAIN_RESOURCES_FOLDER + "XSearchResources.tar.gz", Resources.MAIN_RESOURCES_FOLDER);
        System.out.println("# Resources were downloaded!");
        Resources.X_SEARCH_PROPERTIES_FILE = Resources.MAIN_RESOURCES_FOLDER + "x-search.properties";
        Resources.SUPPORTED_SEARCH_SYSTEMS.put("opensearch", "OpenSearch (http://www.opensearch.org/). The OpenSearch Description Document must be provided.");
        Resources.SUPPORTED_SEARCH_SYSTEMS.put("gcube", "gCube Infrastructure Search System (https://i-marine.d4science.org/web/guest/about-gcube). The ResultSet locator must be provided.");
        Resources.SUPPORTED_SEARCH_SYSTEMS.put("ecoscope", "Ecoscope Search System (http://www.ecoscopebc.ird.fr/)");
        Resources.SUPPORTED_CLUSTERING_ALGORITHMS.put("cl1", "STC: Suffix Tree Clustering Algorithm");
        Resources.SUPPORTED_CLUSTERING_ALGORITHMS.put("cl2", "STC+: Variation of STC which differs in the way the clusters are scored and in the way base clusters are merged (http://users.ics.forth.gr/~tzitzik/publications/Tzitzikas_2009_WISE.pdf)");
        Resources.SUPPORTED_CLUSTERING_ALGORITHMS.put("cl3", "NM-STC: No Merge Suffix Tree Clustering (http://users.ics.forth.gr/~tzitzik/publications/Tzitzikas_2009_WISE.pdf)");
        Resources.SUPPORTED_CLUSTERING_ALGORITHMS.put("cl4", "STC++: Variation of STC+");
        Resources.SUPPORTED_CLUSTERING_ALGORITHMS.put("cl5", "NM-STC+: Variation of NM-STC");
        String clusteringFilename = "clustering.properties";
        String clusteringPropertiesFile = Resources.MAIN_RESOURCES_FOLDER + clusteringFilename;
        File clusteringFile = new File(clusteringPropertiesFile);
        if (!clusteringFile.exists()) {
            try {
                clusteringFile.createNewFile();
                BufferedWriter bw = new BufferedWriter(new FileWriter(clusteringFile, true));
                bw.write("# CLUSTERING PROPERTIES FILE");
                bw.write("\n");
                bw.write("# " + IOSLog.getCurrentDate());
                bw.write("\n");
                bw.write("gr.forth.ics.stellaclustering.resources.useStemming = true");
                bw.write("\n");
                bw.write("gr.forth.ics.stellaclustering.resources.useStopWords = true");
                bw.write("\n");
                bw.write("gr.forth.ics.stellaclustering.resources.stemmer.stopList = " + Resources.MAIN_RESOURCES_FOLDER.replace("\\", "/") + "lexicalAnalyzer/stemmer/stopwords.txt");
                bw.write("\n");
                bw.write("gr.forth.ics.stellaclustering.resources.stemmer.endings = " + Resources.MAIN_RESOURCES_FOLDER.replace("\\", "/") + "lexicalAnalyzer/stemmer/endingsall.txt");
                bw.write("\n");
                bw.write("gr.forth.ics.stellaclustering.resources.stemmer.prefixes = " + Resources.MAIN_RESOURCES_FOLDER.replace("\\", "/") + "lexicalAnalyzer/stemmer/prefixes.txt");
                bw.write("\n");
                bw.write("gr.forth.ics.stellaclustering.resources.stemmer.irregular = " + Resources.MAIN_RESOURCES_FOLDER.replace("\\", "/") + "lexicalAnalyzer/stemmer/irregulars.txt");
                bw.write("\n");
                bw.write("gr.forth.ics.stellaclustering.resources.stemmer.aklita = " + Resources.MAIN_RESOURCES_FOLDER.replace("\\", "/") + "lexicalAnalyzer/stemmer/aklita.txt");
                bw.write("\n");
                bw.write("gr.forth.ics.stellaclustering.resources.stemmer.stemmerLog = " + Resources.MAIN_RESOURCES_FOLDER.replace("\\", "/") + "lexicalAnalyzer/stemmer/Log4J.stemmerProperties");
                bw.write("\n");
                bw.write("\n");
                bw.flush();
                bw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(InitializatorListener.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        String miningFilename = "mining.properties";
        String miningPropertiesFile = Resources.MAIN_RESOURCES_FOLDER + miningFilename;
        File miningFile = new File(miningPropertiesFile);
        if (!miningFile.exists()) {
            try {
                miningFile.createNewFile();
                BufferedWriter bw = new BufferedWriter(new FileWriter(miningFile, true));
                bw.write("# ENTITY MINING PROPERTIES FILE");
                bw.write("\n");
                bw.write("# " + IOSLog.getCurrentDate());
                bw.write("\n");
                bw.write("gr.forth.ics.textentitymining.resources.gateHomeFolder = " + Resources.MAIN_RESOURCES_FOLDER.replace("\\", "/") + "entityMiningNew/");
                bw.write("\n");
                bw.write("gr.forth.ics.textentitymining.resources.maxNumOfTotalEntities = 10000");
                bw.write("\n");
                bw.flush();
                bw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(InitializatorListener.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.out.println("------");
        CLT_Creator.InitializeClusteringProperties((String)clusteringPropertiesFile);
        System.out.println("------");
        GateAnnie.InitializeMiningProperties((String)miningPropertiesFile);
        this.InitializeXSearchProperties(Resources.X_SEARCH_PROPERTIES_FILE);
        System.out.println("------");
        System.out.println("Executing Annie Gate...");
        try {
            GateAnnie.InitializeGate();
        }
        catch (Exception ex) {
            System.out.println("*** Error Initializing GateAnnie: " + ex.getMessage());
        }
        System.out.println("# The system is ready to accept requests!");
        TCPServer server = new TCPServer(Resources.TCP_SERVER_PORT);
        server.start();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        System.out.println("# The context was destroyed! ");
    }

    private void InitializeXSearchProperties(String propertiesFilePath) {
        System.out.println("# Initializing X-Search Properties...");
        try {
            String[] allCategoriesArray;
            String descriptionDocument;
            Properties prop = new Properties();
            FileInputStream in = new FileInputStream(propertiesFilePath);
            prop.load(in);
            String portStr = prop.getProperty("gr.forth.ics.isl.xsearch.resources.tcpport");
            try {
                Resources.TCP_SERVER_PORT = Integer.parseInt(portStr);
            }
            catch (Exception e) {
                System.out.println("*** Using default port: " + Resources.TCP_SERVER_PORT);
            }
            Resources.DESCRIPTIONDOCUMENT = descriptionDocument = prop.getProperty("gr.forth.ics.isl.xsearch.resources.opensearch.descriptionDocument");
            String clusteringAlgorithmString = prop.getProperty("gr.forth.ics.isl.xsearch.resources.clustering.clusteringAlgorithm");
            try {
                int clusteringAlgorithm = Integer.parseInt(clusteringAlgorithmString.trim());
                if (clusteringAlgorithm < 1 || clusteringAlgorithm > 5) {
                    System.out.println("*** NOT APPROPRIATE CLUSTERING ALGORITHM! VALUE NOT AN INTEGER IN THE INTERVAL [1, 5]. SETTING DEFAULT ALGORITHM 3 (NM-STC).");
                    clusteringAlgorithm = 3;
                }
                Resources.CLUSTERING_ALGORITHM = clusteringAlgorithm;
            }
            catch (Exception e) {
                System.out.println("*** NOT APPROPRIATE CLUSTERING ALGORITHM! VALUE NOT AN INTEGER IN THE INTERVAL [1, 5]. SETTING DEFAULT ALGORITHM 3 (NM-STC).");
                Resources.CLUSTERING_ALGORITHM = 3;
            }
            String mineQueryString = prop.getProperty("gr.forth.ics.isl.xsearch.resources.mining.mineQuery");
            Resources.MINE_QUERY = mineQueryString.toLowerCase().equals("true");
            Resources.MINING_ALL_POSSIBLE_CATEGORIES = new HashSet();
            String allCategories = prop.getProperty("gr.forth.ics.isl.xsearch.resources.mining.allPossibleCategories");
            for (String oneCategory : allCategoriesArray = allCategories.split(",")) {
                if (oneCategory.trim().equals("")) continue;
                Resources.MINING_ALL_POSSIBLE_CATEGORIES.add(oneCategory.trim());
            }
            Resources.MINING_ACCEPTED_CATEGORIES = new HashSet();
            String acceptedCategories = prop.getProperty("gr.forth.ics.isl.xsearch.resources.mining.acceptedCategories");
            String[] acceptedCategoriesArray = acceptedCategories.split(",");
            for (String acceptedCategory : acceptedCategoriesArray) {
                if (acceptedCategory.trim().equals("")) continue;
                Resources.MINING_ACCEPTED_CATEGORIES.add(acceptedCategory.trim());
            }
            Resources.SPARQL_ENDPOINTS = new HashMap();
            Resources.SPARQL_TEMPLATES = new HashMap();
            Resources.SPARQL_ENPOINTS_USERNAMES = new HashMap();
            Resources.SPARQL_ENPOINTS_PASSWORDS = new HashMap();
            for (String acceptedCategory : Resources.MINING_ACCEPTED_CATEGORIES) {
                String sparqlEndpointPassword;
                String sparqlEndpointUsername;
                String sparqlTemplate;
                String sparqlEndpoint = prop.getProperty("gr.forth.ics.isl.xsearch.resources.entityenrichment.sparqlendpoint." + acceptedCategory);
                if (sparqlEndpoint != null) {
                    Resources.SPARQL_ENDPOINTS.put(acceptedCategory, sparqlEndpoint.trim());
                }
                if ((sparqlTemplate = prop.getProperty("gr.forth.ics.isl.xsearch.resources.entityenrichment.templatequery." + acceptedCategory)) != null) {
                    Resources.SPARQL_TEMPLATES.put(acceptedCategory, Resources.MAIN_RESOURCES_FOLDER + sparqlTemplate.trim());
                }
                if ((sparqlEndpointUsername = prop.getProperty("gr.forth.ics.isl.xsearch.resources.entityenrichment.sparqlendpoint." + acceptedCategory + ".username")) != null) {
                    Resources.SPARQL_ENPOINTS_USERNAMES.put(sparqlEndpoint, sparqlEndpointUsername.trim());
                }
                if ((sparqlEndpointPassword = prop.getProperty("gr.forth.ics.isl.xsearch.resources.entityenrichment.sparqlendpoint." + acceptedCategory + ".password")) == null) continue;
                Resources.SPARQL_ENPOINTS_PASSWORDS.put(sparqlEndpoint, sparqlEndpointPassword.trim());
            }
            Resources.MINING_RESULTS = Resources.MAIN_RESOURCES_FOLDER + "miningResults/";
            Resources.LOG = Resources.MAIN_RESOURCES_FOLDER + "x-search.log";
            Resources.TEMP_FOLDER = Resources.MAIN_RESOURCES_FOLDER + "tmp/";
            Resources.CONFIGURATIONS_FOLDER = Resources.MAIN_RESOURCES_FOLDER + "configurations/";
            String getPropertiesQuery = prop.getProperty("gr.forth.ics.isl.xsearch.resources.entityenrichment.templatequery.getpropertiesquery");
            Resources.GET_PROPERTIES_TEMPLATE_QUERY = Resources.MAIN_RESOURCES_FOLDER + getPropertiesQuery;
            System.out.println("=> OPENSEARCH DESCRIPTION DOCUMENT: " + Resources.DESCRIPTIONDOCUMENT);
            System.out.println("=> CLUSTERING ALGORITHM: " + Resources.CLUSTERING_ALGORITHM);
            System.out.println("=> MINE QUERY: " + Resources.MINE_QUERY);
            System.out.println("=> MINING ALL POSSIBLE CATEGORIES: " + Resources.MINING_ALL_POSSIBLE_CATEGORIES);
            System.out.println("=> MINING ACCEPTED CATEGORIES: " + Resources.MINING_ACCEPTED_CATEGORIES);
            System.out.println("=> SPARQL ENDPOINTS: " + Resources.SPARQL_ENDPOINTS);
            System.out.println("=> SPARQL ENDPOINTS USERNAMES: " + Resources.SPARQL_ENPOINTS_USERNAMES);
            System.out.println("=> SPARQL ENDPOINTS PASSWORDS: " + Resources.SPARQL_ENPOINTS_PASSWORDS);
            System.out.println("=> SPARQL TEMPLATES: " + Resources.SPARQL_TEMPLATES);
            System.out.println("=> MINING RESULTS FOLDER: " + Resources.MINING_RESULTS);
            System.out.println("=> LOG FOLDER: " + Resources.LOG);
            System.out.println("=> TEMP FOLDER: " + Resources.TEMP_FOLDER);
            System.out.println("=> CONFIGURATIONS FOLDER: " + Resources.CONFIGURATIONS_FOLDER);
            System.out.println("=> GET PROPERTIES TEMPLATE QUERY: " + Resources.GET_PROPERTIES_TEMPLATE_QUERY);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            System.out.println("*** PROBLEM READING X-SEARCH PROPERTIES FILE: " + e.getMessage());
        }
    }
}

