/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch;

import gr.forth.ics.isl.xsearch.Bean_Search;
import gr.forth.ics.isl.xsearch.IOSLog;
import gr.forth.ics.isl.xsearch.resources.Resources;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class Servlet_Search
extends HttpServlet {
    private String query;
    private int n;
    private boolean mining;
    private boolean clustering;
    private boolean only_snippets;
    private int numOfClusters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Servlet_Search servlet_Search = this;
        synchronized (servlet_Search) {
            HashMap templateQueries;
            HashMap endpoints;
            HashSet acceptedCategories;
            response.setContentType("text/html;charset=UTF-8");
            long start = System.currentTimeMillis();
            HttpSession session = request.getSession();
            String descrDoc = (String)session.getAttribute("descrDoc");
            if (descrDoc == null) {
                descrDoc = Resources.DESCRIPTIONDOCUMENT;
            }
            int clusteringAlgorithm = Resources.CLUSTERING_ALGORITHM;
            String clustAlg = (String)session.getAttribute("clustAlg");
            if (clustAlg != null) {
                clusteringAlgorithm = Integer.parseInt(clustAlg);
            }
            boolean mineQuery = Resources.MINE_QUERY;
            String mineQ = (String)session.getAttribute("mineQuery");
            if (mineQ != null) {
                mineQuery = Boolean.parseBoolean(mineQ);
            }
            if ((acceptedCategories = (HashSet)session.getAttribute("acceptedCategories")) == null) {
                acceptedCategories = new HashSet();
                acceptedCategories.addAll(Resources.MINING_ACCEPTED_CATEGORIES);
            }
            if ((endpoints = (HashMap)session.getAttribute("endpoints")) == null) {
                endpoints = new HashMap();
                endpoints.putAll(Resources.SPARQL_ENDPOINTS);
            }
            if ((templateQueries = (HashMap)session.getAttribute("templateQueries")) == null) {
                templateQueries = new HashMap();
                templateQueries.putAll(Resources.SPARQL_TEMPLATES);
            }
            this.query = request.getParameter("query");
            if (this.query == null) {
                this.query = "";
            }
            session.setAttribute("submitted_query", (Object)this.query);
            String num = request.getParameter("n");
            try {
                this.n = Integer.parseInt(num);
            }
            catch (Exception e) {
                this.n = 50;
            }
            String type = request.getParameter("type");
            this.only_snippets = !type.equals("fullContent");
            String mining_checkbox = request.getParameter("mining");
            if (mining_checkbox == null) {
                mining_checkbox = "false";
            }
            this.mining = mining_checkbox.toLowerCase().equals("true");
            String clustering_checkbox = request.getParameter("clustering");
            if (clustering_checkbox == null) {
                clustering_checkbox = "false";
            }
            this.clustering = clustering_checkbox.toLowerCase().equals("true");
            String clnum = request.getParameter("clnum");
            this.numOfClusters = clnum == null ? (this.clustering ? 15 : 0) : Integer.parseInt(clnum);
            Bean_Search results = new Bean_Search(this.query, this.n, this.clustering, this.numOfClusters, this.mining, this.only_snippets, descrDoc, clusteringAlgorithm, mineQuery, acceptedCategories, endpoints, templateQueries);
            session.setAttribute("entities", (Object)results);
            session.setAttribute("docs", (Object)"");
            session.setAttribute("submitted_query", (Object)this.query);
            int numOfResults = results.getWseResults().size();
            long end = System.currentTimeMillis() - start;
            System.out.println("# TOTAL TIME: " + end + " ms.");
            System.out.println("--------");
            this.updateLog(request, this.query, this.n, this.mining, this.clustering, this.only_snippets, this.numOfClusters, numOfResults, end);
            String destination = "search.jsp";
            RequestDispatcher dispatcher = request.getRequestDispatcher(destination);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void updateLog(HttpServletRequest request, String q, int num, boolean mining, boolean clustering, boolean only_snippets, int clnum, int numOfResults, long time) {
        String ip = request.getRemoteAddr();
        String date = IOSLog.getCurrentDate();
        String line = "\nx-search\t" + date + "\t" + ip + "\t" + q.trim() + "\tSUBMITTED NUM=" + num + " MINING=" + mining + " CLUSTERING=" + clustering + " ONLY_SNIPPETS=" + only_snippets + " CLNUM=" + clnum + " NUM_OF_RETURNED_RESULTS=" + numOfResults + " RETRIEVAL_TIME=" + time + "ms";
        IOSLog.writeToLog((String)line);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

