/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl.threads;

import java.io.BufferedWriter;
import java.io.FileWriter;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.usecases.ws.thredds.SyncEngine;
import org.gcube.usecases.ws.thredds.engine.impl.threads.DeleteRemoteRequest;
import org.gcube.usecases.ws.thredds.engine.impl.threads.SynchronizationRequest;
import org.gcube.usecases.ws.thredds.engine.impl.threads.TransferFromThreddsRequest;
import org.gcube.usecases.ws.thredds.engine.impl.threads.TransferToThreddsRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogger {
    private static final Logger log = LoggerFactory.getLogger(RequestLogger.class);
    private static final Object $LOCK = new Object[0];
    private static RequestLogger instance = null;
    BufferedWriter writer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestLogger get() {
        Object object = $LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new RequestLogger();
            }
            return instance;
        }
    }

    private RequestLogger() {
        SyncEngine engine = SyncEngine.get();
        if (engine.isRequestLoggerEnabled()) {
            String path = engine.getRequestLoggerPath();
            log.info("Initializing Request Logger to path {} ", (Object)path);
            try {
                this.writer = new BufferedWriter(new FileWriter(path, false));
            }
            catch (Throwable t) {
                log.warn("Unable to initialize Writer on path {} ", (Object)path, (Object)t);
            }
        }
    }

    public void log(SynchronizationRequest request) {
        if (this.writer != null) {
            SynchronizationRequest transferRequest;
            String logString = "INVALID";
            if (request instanceof DeleteRemoteRequest) {
                DeleteRemoteRequest deleteRequest = (DeleteRemoteRequest)request;
                logString = String.format("DELETE %s from %s (WS-Path: %s)", deleteRequest.getToRemoveName(), RequestLogger.getRemotePath((WorkspaceItem)deleteRequest.getLocation()), RequestLogger.getWSPath((WorkspaceItem)deleteRequest.getLocation()));
            } else if (request instanceof TransferToThreddsRequest) {
                transferRequest = (TransferToThreddsRequest)request;
                logString = String.format("EXPORT %s to %s from %s", RequestLogger.getName(((TransferToThreddsRequest)transferRequest).getToTransfer()), RequestLogger.getRemotePath(((TransferToThreddsRequest)transferRequest).getToTransfer()), RequestLogger.getWSPath(((TransferToThreddsRequest)transferRequest).getToTransfer()));
            } else if (request instanceof TransferFromThreddsRequest) {
                transferRequest = (TransferFromThreddsRequest)request;
                logString = ((TransferFromThreddsRequest)transferRequest).getTargetItem() != null ? String.format("UPDATE LOCAL %s in %s from %s ", RequestLogger.getName(((TransferFromThreddsRequest)transferRequest).getTargetItem()), RequestLogger.getWSPath((WorkspaceItem)transferRequest.getLocation()), RequestLogger.getRemotePath((WorkspaceItem)transferRequest.getLocation())) : String.format("IMPORT LOCAL %s in %s from %s ", ((TransferFromThreddsRequest)transferRequest).getRemoteFilename(), RequestLogger.getWSPath((WorkspaceItem)transferRequest.getLocation()), RequestLogger.getRemotePath((WorkspaceItem)transferRequest.getLocation()));
            }
            try {
                this.writer.write(logString + "\n");
            }
            catch (Throwable t) {
                log.warn("Exception wile trying to write log", t);
            }
        }
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (Throwable t) {
                log.warn("Unable to close writer ", t);
            }
        }
    }

    private static final String getRemotePath(WorkspaceItem item) {
        try {
            if (item.isFolder()) {
                return item.getProperties().getPropertyValue("WS-SYNCH.REMOTE-PATH");
            }
            return RequestLogger.getRemotePath((WorkspaceItem)item.getParent());
        }
        catch (InternalErrorException e) {
            log.warn("Unable to get Remote Path ", (Throwable)e);
            return "N/A";
        }
    }

    private static final String getName(WorkspaceItem item) {
        try {
            return item.getName();
        }
        catch (InternalErrorException e) {
            log.warn("Unable to get name ", (Throwable)e);
            return "N/A";
        }
    }

    private static final String getWSPath(WorkspaceItem item) {
        try {
            if (item.isFolder()) {
                return item.getPath();
            }
            return RequestLogger.getRemotePath((WorkspaceItem)item.getParent());
        }
        catch (InternalErrorException e) {
            log.warn("Unable to get WS Path ", (Throwable)e);
            return "N/A";
        }
    }
}

