/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.persistence.couchdb;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.DocumentNotFoundException;
import org.ektorp.UpdateConflictException;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;
import org.ektorp.http.HttpClient;
import org.ektorp.http.StdHttpClient;
import org.ektorp.impl.StdCouchDbConnector;
import org.ektorp.impl.StdCouchDbInstance;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.configuration.ScheduledTaskConfiguration;
import org.gcube.vremanagement.executor.configuration.jsonbased.JSONLaunchParameter;
import org.gcube.vremanagement.executor.exception.PluginStateNotRetrievedException;
import org.gcube.vremanagement.executor.exception.SchedulePersistenceException;
import org.gcube.vremanagement.executor.exception.ScopeNotMatchException;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConfiguration;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.persistence.couchdb.PluginStateEvolutionObjectNode;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDBPersistenceConnector
extends SmartExecutorPersistenceConnector
implements ScheduledTaskConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CouchDBPersistenceConnector.class);
    protected CouchDbInstance couchDbInstance;
    protected CouchDbConnector couchDbConnector;
    protected static final String DB_NAME = "dbName";
    protected static final String _ID_JSON_FIELD = "_id";
    protected static final String _REV_JSON_FIELD = "_rev";
    protected static final String TYPE_JSON_FIELD = "type";
    protected static final int LAST = -1;
    protected static final String MAP_REDUCE__DESIGN = "_design/";
    protected static final String PLUGIN_STATE_DOCUMENT = "pluginState";
    protected static final String PLUGIN_STATE = "pluginState";
    protected static final String PLUGIN_STATE_VIEW_ABANDONED = "pluginStateABANDONED";
    protected static final String SCHEDULED_TASKS_DOCUMENT = "scheduledTasks";
    protected static final String ACTIVE_VIEW = "active";
    protected static final String ORPHAN_VIEW = "orphan";
    protected static final String USED_BY_FIELD = "usedBy";
    protected static final String STOPPED = "stopped";
    protected static final String RESERVED_BY = "reservedBy";
    protected static final String PREVIOUSLY_USED_BY = "previouslyUsedBy";
    protected static final String RESERVATION_TIMESTAMP = "reservationTimestamp";
    protected static final String SCHEDULED_TASK_TYPE = "scheduledTask";

    public CouchDBPersistenceConnector(SmartExecutorPersistenceConfiguration configuration) throws Exception {
        this.prepareConnection(configuration);
    }

    protected HttpClient initHttpClient(URL url, String username, String password) {
        StdHttpClient.Builder builder = new StdHttpClient.Builder().url(url);
        builder.username(username).password(password);
        HttpClient httpClient = builder.build();
        return httpClient;
    }

    protected void prepareConnection(SmartExecutorPersistenceConfiguration configuration) throws Exception {
        logger.debug("Preparing Connection for {}", (Object)this.getClass().getSimpleName());
        HttpClient httpClient = this.initHttpClient(configuration.getUri().toURL(), configuration.getUsername(), configuration.getPassword());
        this.couchDbInstance = new StdCouchDbInstance(httpClient);
        this.couchDbConnector = new StdCouchDbConnector(configuration.getProperty(DB_NAME), this.couchDbInstance);
    }

    protected ViewResult query(ViewQuery query) {
        ViewResult result = this.couchDbConnector.queryView(query);
        return result;
    }

    public void close() throws Exception {
        this.couchDbConnector.getConnection().shutdown();
    }

    protected void updateItem(JSONObject obj) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(obj.toString());
        this.couchDbConnector.update((Object)node);
    }

    protected JSONObject getObjectByID(String id) throws Exception {
        InputStream is = this.couchDbConnector.getAsStream(id);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
        JSONObject obj = new JSONObject(writer.toString());
        return obj;
    }

    protected void createItem(JSONObject obj, String id) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(obj.toString());
        this.createItem(node, id);
    }

    protected void createItem(JsonNode node, String id) throws Exception {
        if (id != null && id.compareTo("") != 0) {
            this.couchDbConnector.create(id, (Object)node);
        } else {
            this.couchDbConnector.create((Object)node);
        }
    }

    protected void deleteItem(String id, String revision) throws UpdateConflictException, Exception {
        if (revision == null || revision.compareTo("") == 0) {
            JSONObject toDelete = this.getObjectByID(id);
            revision = toDelete.getString(_REV_JSON_FIELD);
        }
        this.couchDbConnector.delete(id, revision);
    }

    public void pluginStateEvolution(PluginStateEvolution pluginStateEvolution) throws Exception {
        ObjectNode objectNode = PluginStateEvolutionObjectNode.getObjectMapper((PluginStateEvolution)pluginStateEvolution);
        this.createItem((JsonNode)objectNode, null);
    }

    @Deprecated
    public PluginState getPluginInstanceState(UUID uuid, int iterationNumber) throws Exception {
        return this.reallyQuery(null, uuid, iterationNumber);
    }

    @Deprecated
    public PluginState getLastPluginInstanceState(UUID uuid) throws Exception {
        return this.reallyQuery(null, uuid, -1);
    }

    protected PluginState reallyQuery(PluginDeclaration pluginDeclaration, UUID uuid, int iterationNumber) throws Exception {
        ViewQuery query = new ViewQuery().designDocId(String.format("%s%s", MAP_REDUCE__DESIGN, "pluginState"));
        String scope = ScopeProvider.instance.get();
        ArrayNode startKey = new ObjectMapper().createArrayNode();
        startKey.add(scope);
        ArrayNode endKey = new ObjectMapper().createArrayNode();
        endKey.add(scope);
        if (pluginDeclaration != null && pluginDeclaration.getName() != null && pluginDeclaration.getName().compareTo("") != 0) {
            startKey.add(pluginDeclaration.getName());
            endKey.add(pluginDeclaration.getName());
            query = query.viewName(PLUGIN_STATE_VIEW_ABANDONED);
        } else {
            query = query.viewName("pluginState");
        }
        startKey.add(uuid.toString());
        endKey.add(uuid.toString());
        if (iterationNumber != -1) {
            startKey.add(iterationNumber);
            endKey.add(iterationNumber);
            startKey.add(1);
            endKey.add("{}");
        } else {
            startKey.add(1);
            endKey.add("{}");
        }
        query.startKey((Object)startKey);
        query.endKey((Object)endKey);
        query.reduce(false);
        PluginState pluginState = null;
        ViewResult viewResult = this.query(query);
        for (ViewResult.Row row : viewResult) {
            JsonNode value = row.getValueAsNode();
            pluginState = PluginState.valueOf((String)value.findValue("state").getTextValue());
        }
        if (pluginState == null) {
            throw new PluginStateNotRetrievedException();
        }
        return pluginState;
    }

    protected List<LaunchParameter> findOrphanedScheduledTasks() {
        return null;
    }

    protected void freeOrphanedScheduledTasks() {
    }

    public List<LaunchParameter> getAvailableScheduledTasks() throws SchedulePersistenceException {
        ViewQuery query = new ViewQuery().designDocId(String.format("%s%s", MAP_REDUCE__DESIGN, SCHEDULED_TASKS_DOCUMENT));
        query = query.viewName(ORPHAN_VIEW);
        String scope = ScopeProvider.instance.get();
        ArrayNode startKey = new ObjectMapper().createArrayNode();
        startKey.add(scope);
        ArrayNode endKey = new ObjectMapper().createArrayNode();
        endKey.add(scope);
        endKey.add("{}");
        query.startKey((Object)startKey);
        query.endKey((Object)endKey);
        ArrayList<LaunchParameter> ret = new ArrayList<LaunchParameter>();
        ViewResult viewResult = this.query(query);
        for (ViewResult.Row row : viewResult) {
            JsonNode value = row.getValueAsNode();
            try {
                JSONObject obj = new JSONObject(value.toString());
                JSONLaunchParameter jlp = new JSONLaunchParameter(obj);
                ret.add((LaunchParameter)jlp);
            }
            catch (ParseException | JSONException e) {
                logger.error("Unable to parse result Row", e.getCause());
            }
            catch (ScopeNotMatchException ex) {
                logger.error("The result row does not macth the current Scope. This should indicate a query error.", ex.getCause());
            }
        }
        return ret;
    }

    public void addScheduledTask(UUID uuid, String consumerID, LaunchParameter parameter) throws SchedulePersistenceException {
        try {
            JSONLaunchParameter jlp = new JSONLaunchParameter(parameter);
            JSONObject obj = jlp.toJSON();
            obj.append(TYPE_JSON_FIELD, (Object)SCHEDULED_TASK_TYPE);
            obj.append(USED_BY_FIELD, (Object)consumerID);
            obj.append("scope", (Object)ScopeProvider.instance.get());
            this.createItem(obj, uuid.toString());
        }
        catch (Exception e) {
            logger.error("Error Adding Scheduled Task UUID : {}, Consumer : {}, LaunchParameter : {}", new Object[]{uuid, consumerID, parameter, e});
            throw new SchedulePersistenceException(e.getCause());
        }
    }

    public void reserveScheduledTask(UUID uuid, String consumerID) throws SchedulePersistenceException {
        try {
            JSONObject obj = this.getObjectByID(uuid.toString());
            String previousConsumerID = obj.getString(USED_BY_FIELD);
            obj.put(PREVIOUSLY_USED_BY, (Object)previousConsumerID);
            obj.remove(USED_BY_FIELD);
            obj.put(RESERVED_BY, (Object)consumerID);
            obj.put(RESERVATION_TIMESTAMP, Calendar.getInstance().getTimeInMillis());
            this.updateItem(obj);
        }
        catch (Exception e) {
            logger.error("Error Reserving Scheduled Task UUID : {} Consumer : {}", new Object[]{uuid, consumerID, e});
            throw new SchedulePersistenceException(e.getCause());
        }
    }

    public void removeScheduledTask(UUID uuid) throws SchedulePersistenceException {
        try {
            JSONObject obj = this.getObjectByID(uuid.toString());
            obj.remove(USED_BY_FIELD);
            obj.put(STOPPED, true);
            this.updateItem(obj);
        }
        catch (Exception e) {
            logger.error("Error Removing Scheduled Task UUID : {}", (Object)uuid, (Object)e);
            throw new SchedulePersistenceException(e.getCause());
        }
    }

    public void releaseScheduledTask(UUID uuid) throws SchedulePersistenceException {
        try {
            JSONObject obj = this.getObjectByID(uuid.toString());
            obj.remove(USED_BY_FIELD);
            this.updateItem(obj);
        }
        catch (Exception e) {
            logger.error("Error Releasing Scheduled Task UUID : {}", (Object)uuid, (Object)e);
            throw new SchedulePersistenceException(e.getCause());
        }
    }

    public LaunchParameter getScheduledTask(UUID uuid) throws SchedulePersistenceException {
        try {
            JSONObject jsonObject = this.getObjectByID(uuid.toString());
            return new JSONLaunchParameter(jsonObject);
        }
        catch (DocumentNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new SchedulePersistenceException(e.getCause());
        }
    }
}

