/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.pluginmanager;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;
import org.gcube.vremanagement.executor.persistence.Persistence;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PluginManager {
    private static Logger logger = LoggerFactory.getLogger(PluginManager.class);
    private static PluginManager pluginManager;
    private Map<String, PluginDeclaration> availablePlugins;

    public static PluginDeclaration getPluginDeclaration(String pluginName) throws PluginNotFoundException {
        logger.debug(String.format("Trying to instantiate a Plugin named %s", pluginName));
        PluginDeclaration pluginDeclaration = PluginManager.getInstance().getPlugin(pluginName);
        if (pluginDeclaration == null) {
            throw new PluginNotFoundException();
        }
        return pluginDeclaration;
    }

    public static Plugin<? extends PluginDeclaration> instantiatePlugin(String pluginName) throws InputsNullException, PluginNotFoundException {
        Plugin instantiatedPlugin;
        Constructor executorPluginConstructor;
        PluginDeclaration pluginDeclaration = PluginManager.getPluginDeclaration((String)pluginName);
        Class plugin = pluginDeclaration.getPluginImplementation();
        logger.debug(String.format("The class which will run the execution will be %s", plugin.getName()));
        Class[] argTypes = new Class[]{pluginDeclaration.getClass()};
        Object[] arguments = new Object[]{pluginDeclaration};
        try {
            executorPluginConstructor = plugin.getDeclaredConstructor(argTypes);
        }
        catch (Exception e) {
            argTypes = new Class[]{pluginDeclaration.getClass(), Persistence.class};
            try {
                executorPluginConstructor = plugin.getDeclaredConstructor(argTypes);
                arguments = new Object[]{pluginDeclaration, null};
            }
            catch (Exception e1) {
                throw new PluginNotFoundException();
            }
        }
        try {
            instantiatedPlugin = (Plugin)executorPluginConstructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new PluginNotFoundException();
        }
        logger.debug(String.format("Plugin named %s has been instantiated", pluginName));
        return instantiatedPlugin;
    }

    public static PluginManager getInstance() {
        if (pluginManager == null) {
            pluginManager = new PluginManager();
        }
        return pluginManager;
    }

    protected PluginManager() {
        logger.debug("Loading plugins available on classpath");
        this.availablePlugins = new HashMap();
        ServiceLoader<PluginDeclaration> serviceLoader = ServiceLoader.load(PluginDeclaration.class);
        for (PluginDeclaration pluginDeclaration : serviceLoader) {
            try {
                logger.debug(String.format("%s plugin found", pluginDeclaration.getName()));
                pluginDeclaration.init();
                String name = pluginDeclaration.getName();
                this.availablePlugins.put(name, pluginDeclaration);
            }
            catch (Exception e) {
                logger.debug(String.format("%s not initialized correctly. It will not be used", pluginDeclaration.getName()));
            }
        }
    }

    public PluginDeclaration getPlugin(String name) {
        return (PluginDeclaration)this.availablePlugins.get(name);
    }

    public Map<String, PluginDeclaration> getAvailablePlugins() {
        return this.availablePlugins;
    }
}

