/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sdmxregistry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtualrepository.AssetType;
import org.virtualrepository.Property;
import org.virtualrepository.csv.CsvCodelist;
import org.virtualrepository.sdmx.SdmxCodelist;
import org.virtualrepository.spi.Browser;
import org.virtualrepository.spi.MutableAsset;

public class RegistryBrowser
implements Browser {
    public static final Logger log = LoggerFactory.getLogger(RegistryBrowser.class);
    private final SDMXRegistryClient endpoint;

    public RegistryBrowser(SDMXRegistryClient endpoint) {
        this.endpoint = endpoint;
    }

    public Iterable<? extends MutableAsset> discover(Collection<? extends AssetType> types) throws Exception {
        if (types.contains(SdmxCodelist.type)) {
            return this.discoverSdmxCodelist();
        }
        if (types.contains(CsvCodelist.type)) {
            return this.discoverCsvCodelist(this.discoverSdmxCodelist());
        }
        throw new IllegalArgumentException("unsupported types " + types);
    }

    public List<SdmxCodelist> discoverSdmxCodelist() throws Exception {
        ArrayList<SdmxCodelist> assets = new ArrayList<SdmxCodelist>();
        SdmxBeans beans = this.endpoint.getCodelist("all", "all", "all", SDMXRegistryClient.Detail.allstubs, SDMXRegistryClient.References.none);
        for (CodelistBean list : beans.getCodelists()) {
            assets.add(this.toAsset(list));
        }
        return assets;
    }

    public List<CsvCodelist> discoverCsvCodelist(List<SdmxCodelist> sdmxCodelists) throws Exception {
        ArrayList<CsvCodelist> assets = new ArrayList<CsvCodelist>();
        for (SdmxCodelist asset : sdmxCodelists) {
            assets.add(this.toCsvAsset(asset));
        }
        return assets;
    }

    private SdmxCodelist toAsset(CodelistBean list) {
        SdmxCodelist asset = new SdmxCodelist(list.getUrn(), list.getId(), list.getVersion(), list.getName());
        try {
            asset.setURI(list.getStructureURL().toURI());
        }
        catch (Exception e) {
            log.trace("invalid structure url for asset " + asset.id());
        }
        if (list.isFinal().isSet()) {
            asset.setStatus(list.isFinal().isTrue() ? "final" : "partial");
        }
        return asset;
    }

    private CsvCodelist toCsvAsset(SdmxCodelist asset) {
        CsvCodelist list = new CsvCodelist(asset.remoteId(), asset.name(), 0, new Property[0]);
        list.properties().add(new Property[]{new Property("urn", (Object)asset.id())});
        list.properties().add(new Property[]{new Property("version", (Object)asset.version())});
        return list;
    }
}

