/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sdmxregistry;

import java.util.Arrays;
import java.util.List;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.virtual.sdmxregistry.Registry;
import org.virtual.sdmxregistry.RegistryBrowser;
import org.virtual.sdmxregistry.RegistryImporter;
import org.virtual.sdmxregistry.RegistryPublisher;
import org.virtual.sdmxregistry.csv.CsvRegistryImporter;
import org.virtualrepository.Utils;
import org.virtualrepository.spi.Browser;
import org.virtualrepository.spi.Importer;
import org.virtualrepository.spi.ServiceProxy;

public abstract class RegistryProxy<T extends Registry>
implements ServiceProxy {
    private final T registry;
    private final RegistryBrowser browser;
    private final RegistryImporter importer;
    private final RegistryPublisher publisher;

    public RegistryProxy(T registry) {
        Utils.notNull((String)"registry proxy", registry);
        this.registry = registry;
        SDMXRegistryClient endpoint = this.endpoint();
        this.browser = new RegistryBrowser(endpoint);
        this.importer = new RegistryImporter(endpoint);
        this.publisher = new RegistryPublisher(endpoint);
    }

    protected T registry() {
        return this.registry;
    }

    public Browser browser() {
        return this.browser;
    }

    public List<Importer<?, ?>> importers() {
        return Arrays.asList(this.importer, new CsvRegistryImporter(this.importer));
    }

    public List<RegistryPublisher> publishers() {
        return Arrays.asList(this.publisher);
    }

    public String toString() {
        return this.registry.toString();
    }

    public abstract SDMXRegistryClient endpoint();
}

