/*
 * Decompiled with CFR 0.152.
 */
package com.control_menu.custom;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"product.navigation.control.menu.category.key=tools", "product.navigation.control.menu.category.order:Integer=3"}, service={ProductNavigationControlMenuEntry.class})
public class CustomSearchProductNavigationControlMenuEntry
implements ProductNavigationControlMenuEntry {
    public String getLabel(Locale locale) {
        return "Search";
    }

    public String getMarkupView(HttpServletRequest httpServletRequest) {
        return "";
    }

    public String getURL(HttpServletRequest httpServletRequest) {
        return "javascript:;";
    }

    public String getLinkCssClass(HttpServletRequest httpServletRequest) {
        return "control-menu-nav-link";
    }

    public boolean includeBody(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String html;
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("custom-search.html");){
            html = new String(is.readAllBytes(), StandardCharsets.UTF_8);
        }
        response.getWriter().println(html);
        return true;
    }

    public boolean includeIcon(HttpServletRequest request, HttpServletResponse response) {
        return false;
    }

    public boolean isPanelStateOpen(HttpServletRequest httpServletRequest, String key) {
        return false;
    }

    public boolean isShow(HttpServletRequest httpServletRequest) throws PortalException {
        return true;
    }

    public boolean isUseDialog() {
        return false;
    }

    public void setPanelState(HttpServletRequest httpServletRequest, String key, String panelState) {
    }

    public Map<String, Object> getData(HttpServletRequest request) {
        return Map.of("qa-id", "custom_search");
    }

    public String getIcon(HttpServletRequest request) {
        return "search";
    }

    public String getIconCssClass(HttpServletRequest httpServletRequest) {
        return "";
    }

    public String getKey() {
        return "custom-search";
    }
}

