/*
 * Decompiled with CFR 0.152.
 */
package org.grade.engine;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hp.hpl.jena.rdf.model.Model;
import java.beans.ConstructorProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.grade.configuration.EndpointConfiguration;
import org.grade.configuration.GraphConfiguration;
import org.grade.configuration.QueryConfiguration;
import org.grade.engine.ExecutionPhase;
import org.grade.engine.ExecutionStatus;
import org.grade.engine.ResultAdapter;
import org.grade.engine.Results;
import org.grade.engine.Sandbox;
import org.grade.repo.Endpoint;
import org.grade.repo.Query;
import org.grade.repo.Task;
import org.grade.repo.impl.memory.MemoryEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskExecution {
    private static final Logger log = LoggerFactory.getLogger(TaskExecution.class);
    public static final String task_execution_task = "task";
    public static final String task_execution_starttime = "start time";
    public static final String task_execution_endtime = "end time";
    public static final String task_execution_duration = "duration";
    public static final String task_execution_status = "status";
    public static final String task_execution_phase = "phase";
    public static final String task_execution_error = "error";
    public static final String task_execution_log = "log";
    public static final String task_execution_source = "source";
    public static final String task_execution_target = "target";
    private static ExecutorService service = Executors.newCachedThreadPool();
    private Future<?> future;
    private Sandbox tbox;
    private Sandbox dbox;
    private Sandbox rbox;
    private Endpoint results;
    private boolean dryrun;
    @JsonProperty(value="id")
    @NonNull
    private String id = UUID.randomUUID().toString();
    @JsonProperty(value="task")
    @NonNull
    private Task task;
    @JsonProperty(value="start time")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd,HH:00")
    private Date startTime;
    @JsonProperty(value="end time")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd,HH:mm")
    private Date endTime;
    @JsonProperty(value="status")
    private ExecutionStatus status = ExecutionStatus.submitted;
    @JsonProperty(value="phase")
    private ExecutionPhase phase = ExecutionPhase.startup;
    @JsonProperty(value="source")
    private EndpointConfiguration source;
    @JsonProperty(value="target")
    private EndpointConfiguration target;
    @JsonProperty(value="log")
    private StringBuilder logs = new StringBuilder();
    @JsonProperty(value="error")
    private String error;

    @JsonGetter(value="duration")
    public String duration() {
        if (this.startTime == null) {
            return null;
        }
        Duration d = Duration.between(this.startTime.toInstant(), this.endTime == null ? Calendar.getInstance().toInstant() : this.endTime.toInstant());
        long mins = d.toMinutes();
        return mins == 0L ? String.format("%02ds %02dms", d.getSeconds() % 60L, d.toMillis() % 1000L) : String.format("%dm %02ds %02dms", mins, d.getSeconds() % 60L, d.toMillis() % 1000L);
    }

    TaskExecution(@NonNull Task task, boolean dryrun) {
        this(task);
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        this.dryrun = dryrun;
    }

    public Future<?> start(final Endpoint source, final Endpoint target) {
        this.results = target;
        this.source = source.configuration();
        this.target = target.configuration();
        this.future = service.submit(new Runnable(){

            @Override
            public void run() {
                TaskExecution.this.startTime = Calendar.getInstance().getTime();
                TaskExecution.this.status(ExecutionStatus.started);
                try {
                    Model transformed = TaskExecution.this.transform(source);
                    try {
                        if (!TaskExecution.this.hasBeenStopped()) {
                            TaskExecution.this.writeout(transformed, target);
                            TaskExecution.this.status(ExecutionStatus.completed);
                            TaskExecution.this.$log("completed task execution in {} msecs.", new Object[]{System.currentTimeMillis() - TaskExecution.this.startTime.getTime()});
                        }
                    }
                    finally {
                        if (Collections.singletonList(transformed).get(0) != null) {
                            transformed.close();
                        }
                    }
                }
                catch (Throwable e) {
                    TaskExecution.this.status(ExecutionStatus.failed);
                    StringWriter w = new StringWriter();
                    e.printStackTrace(new PrintWriter(w));
                    TaskExecution.this.error = w.toString();
                    TaskExecution.this.$log("execution failed (see cause) {}", new Object[]{w.toString()});
                    log.error("execution failed (see cause)", e);
                }
                TaskExecution.this.endTime = Calendar.getInstance().getTime();
                if (TaskExecution.this.dryrun) {
                    target.close();
                }
            }
        });
        return this.future;
    }

    public void stop() {
        if (this.status(ExecutionStatus.stopped)) {
            this.$log("stopping on request...", new Object[0]);
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
    }

    private boolean status(ExecutionStatus status) {
        if (this.status == null || !this.status.isFinal()) {
            this.status = status;
            return true;
        }
        return false;
    }

    private void phase(ExecutionPhase phase) {
        if (this.status == null || !this.status.isFinal()) {
            this.phase = phase;
        }
    }

    public Results results() {
        if (this.status != ExecutionStatus.completed) {
            throw new IllegalStateException("results are not available yet");
        }
        return this.status != ExecutionStatus.completed ? Results.empty : (this.dryrun ? ResultAdapter.adapt(this.tbox) : ResultAdapter.adapt(this.results, this.task.targetGraph()));
    }

    public Results transformation() {
        return this.tbox == null ? Results.empty : ResultAdapter.adapt(this.tbox);
    }

    public Results delta() {
        return this.dbox == null ? Results.empty : ResultAdapter.adapt(this.dbox);
    }

    private Model transform(Endpoint source) {
        this.$log("transforming source graphs: {} ...", this.task.sourceGraphs());
        this.phase(ExecutionPhase.transformation);
        long time = System.currentTimeMillis();
        Query transform = Query.queryWith((QueryConfiguration)QueryConfiguration.query((String)("transform for " + this.task.uri()), (String)source.configuration().uri(), (String)this.task.transformQuery()));
        Model results = (Model)transform.evalAt(source, Collections.emptyMap(), (Collection)this.task.sourceGraphs());
        this.$log("transformation produced {} results in {} msecs.", results.size(), System.currentTimeMillis() - time);
        this.$log("persisting transformation results for later polling (may take seconds) ...", new Object[0]);
        this.tbox = new Sandbox(String.format("%s-%s-%s", this.task.uri(), this.id, "transform"), results);
        this.status(ExecutionStatus.transformed);
        return results;
    }

    private void writeout(Model transform, Endpoint target) {
        long time = System.currentTimeMillis();
        if (this.task.operation() == Task.Operation.publish) {
            this.writeoutPublish(transform, target);
        } else {
            this.writeoutAddRemove(transform, target);
        }
        this.$log("writeout completed in {} msecs.", System.currentTimeMillis() - time);
    }

    private void writeoutPublish(Model transform, Endpoint target) {
        this.phase(ExecutionPhase.writeout);
        String targetUri = this.task.targetGraph();
        this.$log("publishing {} triples in {} (may take seconds) ...", transform.size(), target.configuration().name(), targetUri);
        if (this.dryrun) {
            this.rbox = this.tbox;
        } else {
            GraphConfiguration graph = GraphConfiguration.graph((String)targetUri);
            transform.createResource(targetUri).addProperty(Task.creator_prop, this.task.creator());
            target.create(graph, transform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeoutAddRemove(Model transform, Endpoint target) {
        Model delta = this.computeDeltaOver(transform);
        try {
            if (this.hasBeenStopped()) {
                return;
            }
            this.phase(ExecutionPhase.writeout);
            if (this.task.operation() == Task.Operation.add) {
                this.$log("adding {} triples in {} @ {}", delta.size(), target.configuration().name(), this.task.targetGraph());
                target.addTo(this.task.targetGraph(), delta);
            } else {
                this.$log("removing {} triples from {} @ {}", delta.size(), target.configuration().name(), this.task.targetGraph());
                target.removeFrom(this.task.targetGraph(), delta);
            }
            if (this.dryrun) {
                this.rbox = new Sandbox(String.format("%s-%s-%s", this.task.uri(), this.id, "results"), target.get(this.task.targetGraph()));
            }
        }
        finally {
            if (Collections.singletonList(delta).get(0) != null) {
                delta.close();
            }
        }
    }

    public void dispose() {
        this.stop();
        if (this.tbox != null) {
            this.tbox.dispose();
        }
        if (this.dbox != null) {
            this.dbox.dispose();
        }
        if (this.rbox != null) {
            this.rbox.dispose();
        }
    }

    private Model computeDeltaOver(Model transformation) {
        this.phase(ExecutionPhase.difference);
        this.$log("computing difference between transformation and target", new Object[0]);
        MemoryEndpoint tendpoint = new MemoryEndpoint(transformation, "transformation's temporary endpoint");
        long time = System.currentTimeMillis();
        Query diff = Query.queryWith((QueryConfiguration)QueryConfiguration.query((String)("difference for " + this.task.uri()), (String)" (memory) ", (String)this.task.diffQuery()));
        Model delta = (Model)diff.evalAt((Endpoint)tendpoint);
        this.status(ExecutionStatus.modified);
        this.$log("produced a delta with {} triples in {} msecs.", delta.size(), System.currentTimeMillis() - time);
        this.dbox = new Sandbox(String.format("%s-%s-%s", this.task.uri(), this.id, "delta"), delta);
        return delta;
    }

    private void $log(String msg, Object ... params) {
        log.info("[executing '" + this.task.label() + "']:" + msg, params);
        this.logs.append(MessageFormatter.arrayFormat((String)(this.duration() + ": " + msg), (Object[])params).getMessage()).append("\n");
    }

    private boolean hasBeenStopped() {
        return Thread.interrupted();
    }

    public TaskExecution() {
    }

    @ConstructorProperties(value={"task"})
    public TaskExecution(@NonNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        this.task = task;
    }

    public String toString() {
        return "TaskExecution(future=" + this.future() + ", dryrun=" + this.dryrun() + ", id=" + this.id() + ", task=" + this.task() + ", startTime=" + this.startTime() + ", endTime=" + this.endTime() + ", status=" + (Object)((Object)this.status()) + ", phase=" + (Object)((Object)this.phase()) + ", source=" + this.source() + ", target=" + this.target() + ", logs=" + this.logs() + ", error=" + this.error() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskExecution)) {
            return false;
        }
        TaskExecution other = (TaskExecution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Future<?> this$future = this.future();
        Future<?> other$future = other.future();
        if (this$future == null ? other$future != null : !this$future.equals(other$future)) {
            return false;
        }
        if (this.dryrun() != other.dryrun()) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Task this$task = this.task();
        Task other$task = other.task();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        Date this$startTime = this.startTime();
        Date other$startTime = other.startTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.endTime();
        Date other$endTime = other.endTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        ExecutionStatus this$status = this.status();
        ExecutionStatus other$status = other.status();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        ExecutionPhase this$phase = this.phase();
        ExecutionPhase other$phase = other.phase();
        if (this$phase == null ? other$phase != null : !((Object)((Object)this$phase)).equals((Object)other$phase)) {
            return false;
        }
        EndpointConfiguration this$source = this.source();
        EndpointConfiguration other$source = other.source();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        EndpointConfiguration this$target = this.target();
        EndpointConfiguration other$target = other.target();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        String this$error = this.error();
        String other$error = other.error();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskExecution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Future<?> $future = this.future();
        result = result * 59 + ($future == null ? 0 : $future.hashCode());
        result = result * 59 + (this.dryrun() ? 79 : 97);
        String $id = this.id();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        Task $task = this.task();
        result = result * 59 + ($task == null ? 0 : $task.hashCode());
        Date $startTime = this.startTime();
        result = result * 59 + ($startTime == null ? 0 : ((Object)$startTime).hashCode());
        Date $endTime = this.endTime();
        result = result * 59 + ($endTime == null ? 0 : ((Object)$endTime).hashCode());
        ExecutionStatus $status = this.status();
        result = result * 59 + ($status == null ? 0 : ((Object)((Object)$status)).hashCode());
        ExecutionPhase $phase = this.phase();
        result = result * 59 + ($phase == null ? 0 : ((Object)((Object)$phase)).hashCode());
        EndpointConfiguration $source = this.source();
        result = result * 59 + ($source == null ? 0 : $source.hashCode());
        EndpointConfiguration $target = this.target();
        result = result * 59 + ($target == null ? 0 : $target.hashCode());
        String $error = this.error();
        result = result * 59 + ($error == null ? 0 : $error.hashCode());
        return result;
    }

    public Future<?> future() {
        return this.future;
    }

    public boolean dryrun() {
        return this.dryrun;
    }

    @NonNull
    public String id() {
        return this.id;
    }

    @NonNull
    public Task task() {
        return this.task;
    }

    public Date startTime() {
        return this.startTime;
    }

    public Date endTime() {
        return this.endTime;
    }

    public ExecutionStatus status() {
        return this.status;
    }

    public ExecutionPhase phase() {
        return this.phase;
    }

    public EndpointConfiguration source() {
        return this.source;
    }

    public EndpointConfiguration target() {
        return this.target;
    }

    public StringBuilder logs() {
        return this.logs;
    }

    public String error() {
        return this.error;
    }
}

