/*
 * Decompiled with CFR 0.152.
 */
package org.grade.io.transforms;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.grade.io.transforms.RawTransform;
import org.grade.io.transforms.TransformUtils;

@ApplicationScoped
public class JsonTransform
implements RawTransform<ObjectNode> {
    @Override
    public Class<ObjectNode> type() {
        return ObjectNode.class;
    }

    @Override
    public Model triplify(ObjectNode json) throws Exception {
        Model model = ModelFactory.createDefaultModel();
        this.triplify(json, model);
        return model;
    }

    private void triplify(ObjectNode root, Model model) {
        this.triplify(TransformUtils.mintFor("root"), null, root, model);
    }

    private void triplify(String subject, String predicate, JsonNode json, Model model) {
        if (json.isObject()) {
            this.triplify(subject, predicate, (ObjectNode)json, model);
        } else if (json.isArray()) {
            this.triplify(subject, predicate, (ArrayNode)json, model);
        } else {
            TransformUtils.emitLiteral(model, subject, predicate, json.asText());
        }
    }

    private void triplify(String subject, String predicate, ObjectNode json, Model model) {
        boolean root;
        boolean bl = root = predicate == null;
        if (!root) {
            String object = TransformUtils.mintA(predicate);
            TransformUtils.emit(model, subject, predicate, object);
            subject = object;
        }
        Iterator fields = json.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            this.triplify(subject, (String)field.getKey(), (JsonNode)field.getValue(), model);
        }
    }

    private void triplify(String subject, String predicate, ArrayNode json, Model model) {
        Iterator children = json.elements();
        while (children.hasNext()) {
            JsonNode child = (JsonNode)children.next();
            String childsubject = subject;
            if (child.isArray()) {
                String object = TransformUtils.mintA(predicate);
                TransformUtils.emit(model, subject, predicate, object);
                childsubject = object;
            }
            this.triplify(childsubject, predicate, child, model);
        }
    }

    public String toString() {
        return "Json -> Raw";
    }
}

