/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.grade.configuration.EndpointConfiguration;
import org.grade.repo.Endpoint;
import org.grade.repo.impl.DefaultEndpoint;
import org.grade.repo.impl.memory.MemoryEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Endpoints {
    private static final Logger log = LoggerFactory.getLogger(Endpoints.class);
    final Map<String, MemoryEndpoint> inmemory_map = new HashMap<String, MemoryEndpoint>();
    private List<EndpointConfiguration> configurations;

    public Endpoints(@NonNull List<EndpointConfiguration> configurations, @NonNull Iterable<MemoryEndpoint> inmemory) {
        if (configurations == null) {
            throw new IllegalArgumentException("configurations is null");
        }
        if (inmemory == null) {
            throw new IllegalArgumentException("inmemory is null");
        }
        this.configurations = configurations;
        for (MemoryEndpoint ep : inmemory) {
            this.inmemory_map.put(ep.configuration().name(), ep);
        }
        configurations.stream().forEach($ -> {
            if ($.uri().isEmpty()) {
                MemoryEndpoint mep = this.inmemory_map.get($.name());
                if (mep == null) {
                    throw new IllegalStateException($ + " is not predefined");
                }
                $.id($.name());
                mep.configuration((EndpointConfiguration)$);
            }
            log.info("installed {}", $);
        });
    }

    public List<Endpoint> all() {
        return this.configurations.stream().map(this::endpointFor).collect(Collectors.toList());
    }

    public synchronized Optional<Endpoint> resolveIfExists(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        try {
            return Optional.of(this.resolve(key));
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
    }

    public synchronized Endpoint resolve(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        return this.resolveWith($ -> $.id().equals(key)).orElseGet(() -> this.resolveWith($ -> $.name().equals(key)).orElseThrow(() -> new IllegalStateException("unknown endpoint " + key)));
    }

    public synchronized Endpoint register(@NonNull EndpointConfiguration configuration) {
        boolean removed;
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        if (configuration.uri().isEmpty() && !this.inmemory_map.containsKey(configuration.name())) {
            throw new IllegalArgumentException("missing uri on " + configuration);
        }
        if (configuration.id() == null || configuration.id().isEmpty()) {
            configuration.id(UUID.randomUUID().toString());
        }
        if (!(removed = this.$remove(configuration.id())) && this.configurations.stream().anyMatch($ -> $.name().equals(configuration.name()))) {
            throw new IllegalArgumentException("duplicate endpoint " + configuration.name());
        }
        log.info("{} {}", (Object)(removed ? "replaced" : "registered"), (Object)configuration);
        this.configurations.add(configuration);
        return this.endpointFor(configuration);
    }

    public synchronized void unregister(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        Endpoint ep = this.resolve(key);
        if (ep.configuration().status() == EndpointConfiguration.Status.system) {
            throw new IllegalArgumentException("cannot unregister predefined endpoint '" + ep.configuration().name() + "'");
        }
        if (ep.configuration().locked()) {
            throw new IllegalArgumentException("cannot unregister locked endpoint '" + ep.configuration().name() + "'");
        }
        if (this.$remove(ep.configuration().id())) {
            log.info("unregistered {}", (Object)ep.configuration());
        }
    }

    private boolean $remove(String id) {
        Iterator<EndpointConfiguration> it = this.configurations.iterator();
        while (it.hasNext()) {
            EndpointConfiguration ep = it.next();
            if (!ep.id().equals(id)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    private Optional<Endpoint> resolveWith(Predicate<EndpointConfiguration> pred) {
        return this.configurations.stream().filter(pred).findFirst().map(this::endpointFor);
    }

    private Endpoint endpointFor(EndpointConfiguration $) {
        return $.uri().isEmpty() ? (Endpoint)this.inmemory_map.get($.name()) : new DefaultEndpoint($);
    }
}

