/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo.impl.memory;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.List;
import org.grade.configuration.EndpointConfiguration;
import org.grade.repo.impl.AbstractEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryEndpoint
extends AbstractEndpoint {
    private static final Logger log = LoggerFactory.getLogger(MemoryEndpoint.class);
    private final Dataset dataset;
    private EndpointConfiguration config;

    public MemoryEndpoint(String name) {
        this(DatasetFactory.createMem(), name);
    }

    public MemoryEndpoint(Dataset dataset, String name) {
        this.dataset = dataset;
        this.config = EndpointConfiguration.endpoint((String)name, (String)"").id(name).status(EndpointConfiguration.Status.system);
    }

    public MemoryEndpoint(Model model, String name) {
        this.dataset = DatasetFactory.create((Model)model);
        this.config = EndpointConfiguration.endpoint((String)name, (String)"").id(name).status(EndpointConfiguration.Status.system);
    }

    @Override
    public EndpointConfiguration configuration() {
        return this.config;
    }

    public void configuration(EndpointConfiguration config) {
        this.config = config;
    }

    @Override
    public QueryExecution executionFor(Query query) {
        return QueryExecutionFactory.create((Query)query, (Dataset)this.dataset);
    }

    @Override
    public QueryExecution executionFor(Query query, List<String> graphs) {
        Dataset redux = DatasetFactory.createMem();
        for (String graph : graphs) {
            redux.getDefaultModel().add(this.dataset.getNamedModel(graph));
        }
        return QueryExecutionFactory.create((Query)query, (Dataset)redux);
    }

    @Override
    public void updateWith(UpdateRequest request) {
        UpdateExecutionFactory.create((UpdateRequest)request, (GraphStore)GraphStoreFactory.create((Dataset)this.dataset)).execute();
    }

    @Override
    public void close() {
        log.trace("disposing memory model: {}", (Object)this.config.name());
        this.dataset.close();
    }
}

