/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo.impl;

import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.modify.request.QuadDataAcc;
import com.hp.hpl.jena.sparql.modify.request.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataDelete;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.modify.request.UpdateDrop;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import org.grade.common.GradeUtils;
import org.grade.configuration.GraphConfiguration;
import org.grade.repo.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEndpoint
implements Endpoint {
    private static final Logger log = LoggerFactory.getLogger(AbstractEndpoint.class);
    private static String graphs_query = "SELECT ?g ?l ?c {\t\t { \t\t   graph ?g {  ?g <http://www.w3.org/2000/01/rdf-schema#label> ?l }}{SELECT ?g (COUNT(*) AS ?c)  { \tgraph ?g { ?s ?p ?o  } \t}  GROUP BY ?g}}";
    private static String graph_query = "describe ?s { graph <%s> {?s ?p ?o}}";
    private static String meatadata_query = "construct {<%1$s> ?p ?o} where { graph <%1$s> {<%1$s> ?p ?o}}";
    private static String graph_exists = "ask { graph <%s> {}}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String graphuri) {
        GradeUtils.validUri((String)"graph uri", (String)graphuri);
        QueryExecution exec = this.executionFor(QueryFactory.create((String)String.format(graph_exists, graphuri)));
        try {
            boolean bl = exec.execAsk();
            return bl;
        }
        finally {
            if (Collections.singletonList(exec).get(0) != null) {
                exec.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model get(String graphuri) {
        if (!this.exists(graphuri)) {
            throw new IllegalStateException("unknown graph " + graphuri);
        }
        QueryExecution exec = this.executionFor(QueryFactory.create((String)String.format(graph_query, graphuri)));
        try {
            Model model = exec.execDescribe();
            return model;
        }
        finally {
            if (Collections.singletonList(exec).get(0) != null) {
                exec.close();
            }
        }
    }

    @Override
    public void edit(GraphConfiguration graph) {
        if (!this.exists(graph.uri())) {
            throw new IllegalStateException("unknown graph " + graph.uri());
        }
        UpdateRequest request = UpdateFactory.create();
        String template = String.format("<%s> <http://www.w3.org/2000/01/rdf-schema#label> ?o", graph.uri());
        String insert = String.format("<%s> <http://www.w3.org/2000/01/rdf-schema#label> '%s'", graph.uri(), graph.label());
        request.add(String.format("with <%s> delete { %s } insert { %s} where {%s} ", graph.uri(), template, insert, template));
        this.updateWith(request);
        this.sync();
        log.info("edited graph {} with {}", (Object)graph.uri(), (Object)graph.label());
    }

    @Override
    public void create(GraphConfiguration graph) {
        this.create(graph, ModelFactory.createDefaultModel());
    }

    @Override
    public void create(@NonNull GraphConfiguration graph, Model model) {
        if (graph == null) {
            throw new IllegalArgumentException("graph is null");
        }
        this.preserveOrCreateMetadata(graph, model);
        UpdateDrop drop = new UpdateDrop(graph.uri(), true);
        UpdateCreate create = new UpdateCreate(graph.uri());
        UpdateDataInsert insert = new UpdateDataInsert(this.quadsFor(graph.uri(), model));
        UpdateRequest request = new UpdateRequest((Update)drop).add((Update)create).add((Update)insert);
        this.updateWith(request);
        this.sync();
        log.info("created graph {} with {} triples @ {} in {}", new Object[]{graph, model.size(), this.configuration().writeUri(), this});
    }

    @Override
    public void addTo(String graph, Model model) {
        UpdateDataInsert insert = new UpdateDataInsert(this.quadsFor(graph, model));
        UpdateRequest request = new UpdateRequest((Update)insert);
        this.updateWith(request);
        this.sync();
        log.info("added {} tuples to {} @ {} in {}", new Object[]{model.size(), graph, this.configuration().writeUri(), this});
    }

    @Override
    public void removeFrom(String graph, Model model) {
        GradeUtils.validUri((String)"graph uri", (String)graph);
        UpdateDataDelete delete = new UpdateDataDelete(this.quadsFor(graph, model));
        UpdateRequest request = new UpdateRequest((Update)delete);
        this.updateWith(request);
        this.sync();
        log.info("removed {} tuples from {} @ {} in {}", new Object[]{model.size(), graph, this.configuration().writeUri(), this});
    }

    @Override
    public void remove(String graph) {
        if (this.configuration().locked()) {
            throw new IllegalStateException("cannot remove graph: endpoint is protected");
        }
        GradeUtils.validUri((String)"graph uri", (String)graph);
        this.updateWith(new UpdateRequest((Update)new UpdateDrop(graph)));
        this.sync();
        log.info("deleted graph {} from {}", (Object)graph, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sync() {
        boolean bl;
        block9: {
            Set current = this.configuration().graphs();
            HashSet<GraphConfiguration> clone = new HashSet<GraphConfiguration>();
            log.trace("refreshing graphs for '{}' @ {}", (Object)this.configuration().name(), (Object)(this.configuration().uri().isEmpty() ? "(memory)" : this.configuration().uri()));
            QueryExecution exec = this.executionFor(QueryFactory.create((String)graphs_query));
            try {
                boolean changed;
                ResultSet set = exec.execSelect();
                while (set.hasNext()) {
                    QuerySolution sol = set.next();
                    String uri = sol.getResource("?g").getURI();
                    GraphConfiguration config = GraphConfiguration.graph((String)uri);
                    RDFNode label = sol.get("?l");
                    if (label != null) {
                        config.label(label.toString());
                    }
                    config.size(Integer.valueOf(sol.get("?c").asLiteral().getLexicalForm()).intValue());
                    clone.add(config);
                }
                boolean bl2 = changed = !current.equals(clone);
                if (changed) {
                    this.configuration().graphs(clone);
                }
                bl = changed;
                if (Collections.singletonList(exec).get(0) == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(exec).get(0) != null) {
                        exec.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("cannot inspect " + this, (Throwable)e);
                    return false;
                }
            }
            exec.close();
        }
        return bl;
    }

    public String toString() {
        return this.configuration().toString();
    }

    private QuadDataAcc quadsFor(String uri, Model model) {
        QuadDataAcc quads = new QuadDataAcc();
        quads.setGraph(NodeFactory.createURI((String)uri));
        StmtIterator it = model.listStatements();
        while (it.hasNext()) {
            quads.addTriple(((Statement)it.next()).asTriple());
        }
        return quads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preserveOrCreateMetadata(GraphConfiguration graph, Model model) {
        Query query = QueryFactory.create((String)String.format(meatadata_query, graph.uri()));
        QueryExecution exec = this.executionFor(query);
        try {
            Model metadata = exec.execConstruct();
            System.out.println("metadata " + metadata);
            Resource graphres = model.createResource(graph.uri());
            XSDDateTime now = new XSDDateTime(Calendar.getInstance());
            if (metadata.isEmpty()) {
                graphres.addLiteral(DCTerms.created, ResourceFactory.createTypedLiteral((Object)now));
            } else {
                metadata.removeAll(graphres, RDFS.label, null).removeAll(graphres, DCTerms.modified, null);
            }
            if (graph.label() != null) {
                graphres.addProperty(RDFS.label, graph.label()).addLiteral(DCTerms.modified, ResourceFactory.createTypedLiteral((Object)now));
            }
            model.add(metadata);
        }
        finally {
            if (Collections.singletonList(exec).get(0) != null) {
                exec.close();
            }
        }
    }
}

