/*
 * Decompiled with CFR 0.152.
 */
package org.grade.service.aux;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.jena.riot.Lang;
import org.grade.common.GradeUtils;
import org.grade.service.RestAPI;
import org.grade.service.aux.ResultSetWriter;

@ApplicationScoped
@Provider
@Produces(value={"application/n-triples", "application/sparql-results+json", "application/sparql-results+xml", "text/csv", "text/tab-separated-values", "application/xml", "application/rdf+xml", "text/xml", "application/json", "application/ld+json", "application/x-turtle", "text/turtle"})
public class ModelWriter
implements MessageBodyWriter<Model> {
    @Inject
    ResultSetWriter rswriter;
    private final Query model2ResultSetQuery = QueryFactory.create((String)"select ?subject ?predicate ?object where {?subject ?predicate ?object}");

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Model.class.isAssignableFrom(type);
    }

    public long getSize(Model model, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Model model, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        block11: {
            try {
                if (mediaType.equals((Object)RestAPI.APPLICATION_SPARQL_RESULTS_XML_TYPE) || mediaType.equals((Object)RestAPI.APPLICATION_SPARQL_RESULTS_JSON_TYPE) || mediaType.equals((Object)RestAPI.TEXT_CSV_TYPE) || mediaType.equals((Object)RestAPI.TEXT_TSV_TYPE)) {
                    QueryExecution exec = QueryExecutionFactory.create((Query)this.model2ResultSetQuery, (Model)model);
                    try {
                        ResultSet set = exec.execSelect();
                        this.rswriter.writeTo(set, type, genericType, annotations, mediaType, httpHeaders, entityStream);
                        break block11;
                    }
                    finally {
                        if (Collections.singletonList(exec).get(0) != null) {
                            exec.close();
                        }
                    }
                }
                if (mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE) || mediaType.equals((Object)RestAPI.APPLICATION_RDF_XML_TYPE) || mediaType.equals((Object)MediaType.TEXT_XML_TYPE)) {
                    model.write(entityStream, Lang.RDFXML.getName());
                    break block11;
                }
                if (mediaType.equals((Object)RestAPI.TEXT_TURTLE_TYPE) || mediaType.equals((Object)RestAPI.APPLICATION_TURTLE_TYPE)) {
                    model.write(entityStream, Lang.TTL.getName());
                    break block11;
                }
                if (mediaType.equals((Object)RestAPI.APPLICATION_NTRIPLES_TYPE)) {
                    model.write(entityStream, Lang.NTRIPLES.getName());
                    break block11;
                }
                if (mediaType.equals((Object)RestAPI.APPLICATION_JSONLD_TYPE) || mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                    model.write(entityStream, Lang.JSONLD.getName());
                    break block11;
                }
                throw new AssertionError((Object)("GRADE ERROR: " + mediaType + " dispatched but not handled"));
            }
            catch (Exception e) {
                throw GradeUtils.unchecked((String)"cannot serialise model (see cause) ", (Throwable)e);
            }
        }
    }
}

