/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.wrappers;

import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.wrappers.ISOmetadataFactory;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.wrappers.MetaDataImpL;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.gcube.spatial.data.geonetwork.iso.EnvironmentConfiguration;
import org.gcube.spatial.data.geonetwork.iso.MissingInformationException;
import org.gcube.spatial.data.geonetwork.iso.Thesaurus;
import org.gcube.spatial.data.geonetwork.utils.StringValidator;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.spatial.GeometricObjectType;
import org.opengis.metadata.spatial.TopologyLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcubeISOmetadata {
    private static Logger log = LoggerFactory.getLogger(GcubeISOmetadata.class);
    private EnvironmentConfiguration config;
    private String user = null;
    private String title = null;
    private Date creationDate = null;
    private PresentationForm presentationForm = null;
    private String abstractField = null;
    private String purpose = null;
    private ArrayList<String> credits = new ArrayList();
    private HashMap<Thesaurus, HashSet<String>> descriptiveKeywords = new HashMap();
    private ArrayList<TopicCategory> topicCategories = new ArrayList();
    private ExtentImpl extent = (ExtentImpl)ExtentImpl.WORLD;
    private GeometricObjectType geometricObjectType = GeometricObjectType.SURFACE;
    private int geometryCount = 0;
    private TopologyLevel topologyLevel = TopologyLevel.GEOMETRY_ONLY;
    private double resolution = 0.5;
    private ArrayList<String> graphicOverviewsURI = new ArrayList();

    public GcubeISOmetadata() {
        log.debug("Initialize GcubeISOmetadata...");
        try {
            this.config = EnvironmentConfiguration.getConfiguration();
        }
        catch (Exception e) {
            log.error("Problem while getting configuration: ", (Throwable)e);
        }
        this.credits.add(this.config.getProjectCitation());
        this.addKeyword(this.config.getProjectName(), (Thesaurus)this.config.getThesauri().get("General"));
    }

    protected void checkConstraints() throws MissingInformationException {
        log.debug("Entering checkConstraints...");
        if (!StringValidator.isValidateString((String)this.getUser())) {
            log.error("Field user is mandatory");
            throw new MissingInformationException("Field user is mandatory");
        }
        if (!StringValidator.isValidateString((String)this.getTitle())) {
            log.error("Field title is mandatory");
            throw new MissingInformationException("Field title is mandatory");
        }
        if (this.getCreationDate() == null) {
            log.error("Field creationDate is mandatory");
            throw new MissingInformationException("Field creationDate is mandatory");
        }
        if (this.getPresentationForm() == null) {
            log.error("Field presentationForm is mandatory");
            throw new MissingInformationException("Field presentationForm is mandatory");
        }
        if (!StringValidator.isValidateString((String)this.getAbstractField())) {
            log.error("Field abstractField is mandatory");
            throw new MissingInformationException("Field abstractField is mandatory");
        }
        if (!StringValidator.isValidateString((String)this.getPurpose())) {
            log.error("Field purpose is mandatory");
            throw new MissingInformationException("Field purpose is mandatory");
        }
        if (this.getTopicCategories().size() == 0) {
            log.error("At least one topic category is required");
            throw new MissingInformationException("At least one topic category is required");
        }
        if (this.getExtent() == null) {
            log.error("Field Extent is mandatory");
            throw new MissingInformationException("Field Extent is mandatory");
        }
        if (this.getGeometricObjectType() == null) {
            log.error("Field geometricObjectType is mandatory");
            throw new MissingInformationException("Field geometricObjectType is mandatory");
        }
        if (this.getTopologyLevel() == null) {
            log.error("Field topology level is mandatory");
            throw new MissingInformationException("Field topology level is mandatory");
        }
        if (this.getCredits().size() == 0) {
            log.error("At least one credits is needed");
            throw new MissingInformationException("At least one credits is needed");
        }
        if (this.getDescriptiveKeywords().isEmpty()) {
            log.error("Missing Descriptive keywords");
            throw new MissingInformationException("Missing Descriptive keywords");
        }
    }

    public MetaDataImpL getMetadata() {
        try {
            this.checkConstraints();
        }
        catch (MissingInformationException e) {
            log.error("Problem while checking constraints: " + (Object)((Object)e));
        }
        try {
            return ISOmetadataFactory.generateMeta(this);
        }
        catch (URISyntaxException e) {
            log.error("Problem while generating metadata: " + e);
            return null;
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public PresentationForm getPresentationForm() {
        return this.presentationForm;
    }

    public void setPresentationForm(PresentationForm presentationForm) {
        this.presentationForm = presentationForm;
    }

    public String getAbstractField() {
        return this.abstractField;
    }

    public void setAbstractField(String abstractField) {
        this.abstractField = abstractField;
    }

    public ExtentImpl getExtent() {
        return this.extent;
    }

    public void setExtent(ExtentImpl extent) {
        this.extent = extent;
    }

    public GeometricObjectType getGeometricObjectType() {
        return this.geometricObjectType;
    }

    public void setGeometricObjectType(GeometricObjectType geometricObjectType) {
        this.geometricObjectType = geometricObjectType;
    }

    public int getGeometryCount() {
        return this.geometryCount;
    }

    public void setGeometryCount(int geometryCount) {
        this.geometryCount = geometryCount;
    }

    public EnvironmentConfiguration getConfig() {
        return this.config;
    }

    public ArrayList<String> getCredits() {
        return (ArrayList)this.credits.clone();
    }

    public void addCredits(String toAddCredits) {
        this.credits.add(toAddCredits);
    }

    public HashMap<Thesaurus, HashSet<String>> getDescriptiveKeywords() {
        return (HashMap)this.descriptiveKeywords.clone();
    }

    public synchronized void addKeyword(String keyword, Thesaurus thesaurus) {
        if (!this.descriptiveKeywords.containsKey(thesaurus)) {
            this.descriptiveKeywords.put(thesaurus, new HashSet());
        }
        this.descriptiveKeywords.get(thesaurus).add(keyword);
    }

    public ArrayList<TopicCategory> getTopicCategories() {
        return (ArrayList)this.topicCategories.clone();
    }

    public void addTopicCategory(TopicCategory toAdd) {
        this.topicCategories.add(toAdd);
    }

    public ArrayList<String> getGraphicOverviewsURI() {
        return (ArrayList)this.graphicOverviewsURI.clone();
    }

    public void addGraphicOverview(String uri) {
        this.graphicOverviewsURI.add(uri);
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GcubeISOMetadata [config=");
        builder.append(this.config);
        builder.append(", user=");
        builder.append(this.user);
        builder.append(", title=");
        builder.append(this.title);
        builder.append(", creationDate=");
        builder.append(this.creationDate);
        builder.append(", presentationForm=");
        builder.append(this.presentationForm);
        builder.append(", abstractField=");
        builder.append(this.abstractField);
        builder.append(", credits=");
        builder.append(this.credits);
        builder.append(", descriptiveKeywords=");
        builder.append(this.descriptiveKeywords);
        builder.append(", topicCategories=");
        builder.append(this.topicCategories);
        builder.append(", extent=");
        builder.append(this.extent);
        builder.append(", geometricObjectType=");
        builder.append(this.geometricObjectType);
        builder.append(", geometryCount=");
        builder.append(this.geometryCount);
        builder.append(", graphicOverviewsURI=");
        builder.append(this.graphicOverviewsURI);
        builder.append("]");
        return builder.toString();
    }

    public TopologyLevel getTopologyLevel() {
        return this.topologyLevel;
    }

    public void setTopologyLevel(TopologyLevel topologyLevel) {
        this.topologyLevel = topologyLevel;
    }

    public double getResolution() {
        return this.resolution;
    }

    public void setResolution(double resoulution) {
        this.resolution = resoulution;
    }
}

