/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.project.dao;

import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.project.ProjectTerm;
import gr.cite.geoanalytics.dataaccess.entities.project.dao.ProjectTermDao;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.Taxonomy;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTerm;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;
import java.util.List;
import java.util.UUID;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Repository;

@Repository
public class ProjectTermDaoImpl
extends JpaDao<ProjectTerm, UUID>
implements ProjectTermDao {
    @Override
    public ProjectTerm find(Project p, TaxonomyTerm tt) {
        TypedQuery query = this.entityManager.createQuery("from ProjectTerm pt where pt.term = :t and pt.project = :p", ProjectTerm.class);
        query.setParameter("t", (Object)tt);
        query.setParameter("p", (Object)p);
        try {
            return (ProjectTerm)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<TaxonomyTerm> findByProject(Project p) {
        TypedQuery query = this.entityManager.createQuery("select pt.term from ProjectTerm pt where pt.project = :p", TaxonomyTerm.class);
        query.setParameter("p", (Object)p);
        return query.getResultList();
    }

    @Override
    public List<Taxonomy> findByTenant(Tenant tenant) {
        TypedQuery query = this.entityManager.createQuery("select t2 from Taxonomy t2 where t2.id in (select distinct t.id from ProjectTerm pt join pt.term tt join tt.taxonomy t join pt.project p join p.creator u where u.tenant = :tenant)", Taxonomy.class);
        query.setParameter("tenant", (Object)tenant);
        return query.getResultList();
    }

    @Override
    public TaxonomyTerm findByProjectAndTaxonomy(Project p, Taxonomy t) {
        TypedQuery query = this.entityManager.createQuery("select pt.term from ProjectTerm pt, TaxonomyTerm tt where pt.project = :p and pt.term = tt and tt.taxonomy = :t", TaxonomyTerm.class);
        query.setParameter("p", (Object)p);
        query.setParameter("t", (Object)t);
        try {
            return (TaxonomyTerm)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<Project> findByTerm(TaxonomyTerm tt) {
        TypedQuery query = this.entityManager.createQuery("select pt.project from ProjectTerm pt where pt.term = :tt", Project.class);
        query.setParameter("tt", (Object)tt);
        return query.getResultList();
    }

    @Override
    public void deleteByProject(Project p) {
        Query query = this.entityManager.createQuery("delete ProjectTerm pt where pt.project = :p");
        query.setParameter("p", (Object)p);
        query.executeUpdate();
    }

    @Override
    public void deleteByTerm(TaxonomyTerm tt) {
        Query query = this.entityManager.createQuery("delete ProjectTerm pt where pt.term = :tt");
        query.setParameter("tt", (Object)tt);
        query.executeUpdate();
    }

    @Override
    public ProjectTerm loadDetails(ProjectTerm pt) {
        pt.getCreator().getName();
        pt.getProject().getId();
        pt.getTerm().getId();
        return pt;
    }
}

