/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.markwkt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.renderer.style.shape.ExplicitBoundsShape;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;

public class MeteoMarkFactory
implements MarkFactory {
    public static final String SHAPE_PREFIX = "extshape://";
    private static final Logger LOGGER = Logging.getLogger(MeteoMarkFactory.class);
    public static final String ARROW_HEIGHT_RATIO_KEY = "hr";
    public static final String ARROW_THICKNESS_KEY = "t";
    public static final String ARROWHEAD_BASE_KEY = "ab";
    protected static final Map<String, Shape> WELLKNOWN_SHAPES = new HashMap<String, Shape>();

    @Override
    public Shape getShape(Graphics2D graphics, Expression symbolUrl, Feature feature) throws Exception {
        String localName;
        String wellKnownName;
        if (symbolUrl == null) {
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Trying to resolve symbol:" + symbolUrl.toString());
        }
        if ((wellKnownName = symbolUrl.evaluate(feature, String.class)) == null || !wellKnownName.startsWith(SHAPE_PREFIX)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to resolve symbol");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Resolved symbol");
        }
        if ((localName = wellKnownName.substring(SHAPE_PREFIX.length())).startsWith("arrow?")) {
            return this.buildDynamicArrow(localName);
        }
        return WELLKNOWN_SHAPES.get(localName);
    }

    private Shape buildDynamicArrow(String name) {
        Map<String, String> params = this.getParams(name);
        float height = 1.0f;
        float thickness = 0.2f;
        float arrowBase = 0.5f;
        block12: for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String svalue = entry.getValue();
            float value = 0.0f;
            try {
                value = Float.valueOf(svalue).floatValue();
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid numerical value " + svalue);
            }
            switch (key) {
                case "hr": {
                    this.validateRange(key, value, 0.0, 1000.0);
                    height = value;
                    continue block12;
                }
                case "t": {
                    this.validateRange(key, value, 0.0, 1.0);
                    thickness = value;
                    continue block12;
                }
                case "ab": {
                    this.validateRange(key, value, 0.0, 1.0);
                    arrowBase = value;
                    continue block12;
                }
            }
            LOGGER.warning("Unexpected key value pair " + key + "=" + svalue + " for extshape://arrow");
        }
        return MeteoMarkFactory.buildDynamicArrow(height, thickness, arrowBase);
    }

    private static Shape buildDynamicArrow(float height, float thickness, float arrowBase) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, height / 2.0f);
        float arrowBaseHeight = height / 2.0f - height * (1.0f - arrowBase);
        gp.lineTo(0.5, (double)arrowBaseHeight);
        float t2 = thickness / 2.0f;
        if ((double)t2 < 0.5) {
            gp.lineTo(t2, arrowBaseHeight);
        }
        gp.lineTo(t2, -height / 2.0f);
        if (t2 > 0.0f) {
            gp.lineTo(-t2, -height / 2.0f);
        }
        if ((double)t2 < 0.5) {
            gp.lineTo(-t2, arrowBaseHeight);
        }
        gp.lineTo(-0.5f, arrowBaseHeight);
        gp.closePath();
        return gp;
    }

    private void validateRange(String key, double value, double min, double max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("Invalid value " + value + " for key " + key + ", should have been between " + min + " and " + max + " (extreme excluded)");
        }
    }

    private Map<String, String> getParams(String name) {
        String[] keyValues;
        HashMap<String, String> params = new HashMap<String, String>();
        String kvpPart = name.substring(name.indexOf(63) + 1);
        for (String keyValue : keyValues = kvpPart.split("&")) {
            String[] kv = keyValue.split("=");
            if (kv.length != 2 || kv[0].isEmpty() || kv[1].isEmpty()) {
                LOGGER.fine("Skipping invalid kvp pair " + keyValue);
            }
            params.put(kv[0], kv[1]);
        }
        return params;
    }

    static {
        GeneralPath gp = new GeneralPath();
        gp = new GeneralPath();
        ExplicitBoundsShape bnd = null;
        gp.moveTo(-0.145f, 0.0f);
        gp.lineTo(0.0f, 0.175f);
        gp.lineTo(0.105f, 0.0f);
        gp.closePath();
        bnd = new ExplicitBoundsShape(gp);
        bnd.setBounds(new Rectangle2D.Double(-0.5, -0.5, 0.5, 0.5));
        WELLKNOWN_SHAPES.put("triangle", bnd);
        gp = new GeneralPath();
        gp.moveTo(-0.125f, 0.0f);
        gp.curveTo(-0.125f, 0.0f, 0.0f, 0.25f, 0.125f, 0.0f);
        gp.closePath();
        bnd = new ExplicitBoundsShape(gp);
        bnd.setBounds(new Rectangle2D.Double(-0.5, -0.5, 0.5, 0.5));
        WELLKNOWN_SHAPES.put("emicircle", bnd);
        gp = new GeneralPath();
        gp.moveTo(-0.395f, 0.0f);
        gp.lineTo(-0.25f, -0.175f);
        gp.lineTo(-0.145f, 0.0f);
        gp.moveTo(0.125f, 0.0f);
        gp.curveTo(0.125f, 0.0f, 0.25f, 0.25f, 0.375f, 0.0f);
        gp.closePath();
        bnd = new ExplicitBoundsShape(gp);
        bnd.setBounds(new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0));
        WELLKNOWN_SHAPES.put("triangleemicircle", bnd);
        gp = new GeneralPath();
        gp.moveTo(0.0f, 1.0f);
        gp.lineTo(0.5, 0.0);
        gp.lineTo(0.1f, 0.0f);
        gp.lineTo(0.1f, -1.0f);
        gp.lineTo(-0.1f, -1.0f);
        gp.lineTo(-0.1f, 0.0f);
        gp.lineTo(-0.5f, 0.0f);
        gp.closePath();
        WELLKNOWN_SHAPES.put("narrow", gp);
        AffineTransform at = AffineTransform.getQuadrantRotateInstance(2);
        gp = new GeneralPath();
        gp.moveTo(0.0f, 1.0f);
        gp.lineTo(0.5, 0.0);
        gp.lineTo(0.1f, 0.0f);
        gp.lineTo(0.1f, -1.0f);
        gp.lineTo(-0.1f, -1.0f);
        gp.lineTo(-0.1f, 0.0f);
        gp.lineTo(-0.5f, 0.0f);
        gp.closePath();
        gp.transform(at);
        WELLKNOWN_SHAPES.put("sarrow", gp);
        WELLKNOWN_SHAPES.put("arrow", MeteoMarkFactory.buildDynamicArrow(2.0f, 0.2f, 0.5f));
    }
}

