/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.opengis.filter.expression.Function;

public class ColorMapImpl
implements ColorMap {
    private final Function function;
    private List<ColorMapEntry> list = new ArrayList<ColorMapEntry>();
    private int type = 1;
    private boolean extendedColors;

    public ColorMapImpl() {
        this.function = null;
    }

    public ColorMapImpl(Function function) {
        this.function = function;
    }

    @Override
    public void addColorMapEntry(ColorMapEntry entry) {
        this.list.add(entry);
    }

    @Override
    public ColorMapEntry[] getColorMapEntries() {
        return this.list.toArray(new ColorMapEntry[0]);
    }

    @Override
    public ColorMapEntry getColorMapEntry(int index) {
        return this.list.get(index);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        if (type < 1 || type > 3) {
            throw new IllegalArgumentException();
        }
        this.type = type;
    }

    @Override
    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean getExtendedColors() {
        return this.extendedColors;
    }

    @Override
    public void setExtendedColors(boolean extended) {
        this.extendedColors = extended;
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.function != null) {
            result = 1000003 * result + this.function.hashCode();
        }
        if (this.list != null) {
            result = 1000003 * result + this.list.hashCode();
        }
        result = 1000003 * result + this.type;
        result = 1000003 * result + (this.extendedColors ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ColorMapImpl) {
            ColorMapImpl other = (ColorMapImpl)obj;
            return Utilities.equals(this.function, other.function) && Utilities.equals(this.list, other.list) && Utilities.equals(this.type, other.type) && Utilities.equals(this.extendedColors, other.extendedColors);
        }
        return false;
    }

    static ColorMapImpl cast(org.opengis.style.ColorMap colorMap) {
        if (colorMap == null) {
            return null;
        }
        if (colorMap instanceof ColorMapImpl) {
            return (ColorMapImpl)colorMap;
        }
        return null;
    }
}

