/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio.geotiff;

import org.geotools.util.Utilities;

public final class TiePoint {
    private double[] values = new double[6];

    public TiePoint() {
    }

    public TiePoint(double i, double j, double k, double x, double y, double z) {
        this.set(i, j, k, x, y, z);
    }

    public void set(double i, double j, double k, double x, double y, double z) {
        this.values[0] = i;
        this.values[1] = j;
        this.values[2] = k;
        this.values[3] = x;
        this.values[4] = y;
        this.values[5] = z;
    }

    public double getValueAt(int index) {
        if (index < 0 || index > 5) {
            throw new IllegalArgumentException("Provided index should be between 0 and 5");
        }
        return this.values[index];
    }

    public double[] getData() {
        return (double[])this.values.clone();
    }

    public boolean isSet() {
        for (double val : this.values) {
            if (this.isComponentSet(val)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TiePoint)) {
            return false;
        }
        TiePoint that = (TiePoint)obj;
        return Utilities.deepEquals(this.values, that.values);
    }

    public int hashCode() {
        return Utilities.deepHashCode(this.values);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Tie point").append("\n");
        builder.append("\tRaster Space point (").append(this.values[0]).append(", ").append(this.values[1]).append(", ").append(this.values[2]).append(")").append("\n");
        builder.append("\tModel Space point (").append(this.values[3]).append(", ").append(this.values[4]).append(", ").append(this.values[5]).append(")");
        return builder.toString();
    }

    private boolean isComponentSet(double value) {
        return !Double.isInfinite(value) && !Double.isNaN(value) && Math.abs(value) > 1.0E-6;
    }
}

